<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2020 Amasty (https://www.amasty.com)
 * @package Amasty_Customform
 */


namespace Amasty\Customform\Controller\Form;

use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Amasty\Customform\Helper\Data;
use Amasty\Customform\Model\AnswerRepository;
use Magento\Framework\Api\FilterFactory;
use Magento\Customer\Model\SessionFactory;
use Magento\Framework\App\Http\Context as HttpContext;
use Amasty\Customform\Api\Data\AnswerInterface;
use Magento\Framework\Api\Search\FilterGroupFactory;

class Survey extends Action
{
    /**
     * @var Data
     */
    private $helper;

    /**
     * @var JsonFactory
     */
    private $resultJsonFactory;

    /**
     * @var AnswerRepository
     */
    private $answerRepository;

    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * @var FilterFactory
     */
    private $filterFactory;

    /**
     * @var SessionFactory
     */
    private $customerSessionFactory;

    /**
     * @var HttpContext
     */
    private $httpContext;

    /**
     * @var FilterGroupFactory
     */
    private $filterGroupFactory;

    public function __construct(
        Context $context,
        Data $helper,
        JsonFactory $resultJsonFactory,
        AnswerRepository $answerRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterFactory $filterFactory,
        FilterGroupFactory $filterGroupFactory,
        SessionFactory $customerSessionFactory,
        HttpContext $httpContext
    ) {
        $this->helper = $helper;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->answerRepository = $answerRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->filterFactory = $filterFactory;
        $this->customerSessionFactory = $customerSessionFactory;
        $this->httpContext = $httpContext;
        $this->filterGroupFactory = $filterGroupFactory;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $formId = (int)$this->getRequest()->getParam('form_id');
        $result = $this->resultJsonFactory->create();
        $list = [];
        if ($formId) {
            try {
                $list = $this->answerRepository->getListFilter($this->prepareSearchCriteria($formId));
            } catch (\Magento\Framework\Exception\NoSuchEntityException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                $list = [];
            }

        }
        $result->setData(['isSurveyAvailable' => !count($list)]);

        return $result;
    }

    /**
     * @param int $formId
     * @return \Magento\Framework\Api\SearchCriteria
     */
    private function prepareSearchCriteria($formId)
    {
        $filter = $this->filterFactory->create()->setField(AnswerInterface::FORM_ID)
            ->setValue($formId)
            ->setConditionType('eq');
        $filterGroup1 = $this->filterGroupFactory->create()->setFilters([$filter]);

        if ($this->httpContext->getValue(\Magento\Customer\Model\Context::CONTEXT_AUTH)) {
            $filters[] = $this->filterFactory->create()->setField(AnswerInterface::CUSTOMER_ID)
                ->setValue($this->customerSessionFactory->create()->getId())
                ->setConditionType('eq');
        }
        $filters[] = $this->filterFactory->create()->setField(AnswerInterface::IP)
            ->setValue($this->helper->getCurrentIp())
            ->setConditionType('eq');
        $filterGroup2 = $this->filterGroupFactory->create()->setFilters($filters);
        $this->searchCriteriaBuilder->setFilterGroups([$filterGroup1, $filterGroup2]);

        return $this->searchCriteriaBuilder->create();
    }
}
