define([
    'jquery',
    'jquery/validate'
], function ($) {
    'use_strict';

    $.widget('mage.amFormSession', {
        options: {
            urlSession: '',
            formId: 0
        },

        _create: function () {
            this.initialization();
        },

        initialization: function () {
            var self = this;
            $.ajax({
                url: self.options.urlSession,
                dataType: 'json',
                type: 'post',
                data: {'form_id': self.options.formId},
                success: function(response) {
                    self.checkFieldType(response);
                },
                error: function(error) {
                    console.log(error)
                }
            });
        },

        checkFieldType: function (fields) {
            var formData = this.element,
                field = '';

            $.each(fields, function (name, value) {
                field = formData.find('[data-amcform-js="' + name + '"]');

                if (field.length) {
                    switch (field.attr('type')) {
                        case 'select':
                            var optionItems = field.children();
                            $.each(optionItems, function (item, option) {
                                $(option).prop('selected', false);
                                var currentOptValue = $(option).val();
                                if (currentOptValue === value || (Array.isArray(value) && value.includes(currentOptValue))) {
                                    $(this).prop('selected', true);
                                }
                            });
                            break;
                        case 'radio':
                            var checkedField = value.split('-'),
                                selector = name + '-' + (checkedField[1] - 1);

                            $('#' + selector).prop('checked', true);
                            break;
                        case 'checkbox':
                            field.prop('checked', false);
                            $.each(value, function (index, val) {
                                var checkedField = val.split('-'),
                                    selector = name + '-' + (checkedField[1] - 1);

                                $('#' + selector).prop('checked', true);
                            });
                            break;
                        default:
                            field.val(value);
                    }
                }
            });
        },
    });

    return $.mage.amFormSession;
});
