<?php

namespace Amasty\PageSpeedOptimizer\Model\OptionSource;

use Magento\Framework\Data\OptionSourceInterface;

class BundlingType implements OptionSourceInterface
{
    const SIMPLE = 0;
    const SUPER_BUNDLING = 1;

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $optionArray = [];
        foreach ($this->toArray() as $widgetType => $label) {
            $optionArray[] = ['value' => $widgetType, 'label' => $label];
        }
        return $optionArray;
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            self::SIMPLE => __('Disabled'),
            self::SUPER_BUNDLING => __('Enabled (Recommended)'),
        ];
    }
}
