<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2021 Amasty (https://www.amasty.com)
 * @package Amasty_Shopby
 */


namespace Amasty\Shopby\Model\Source;

/**
 * Class SubmitMode
 * @package Amasty\Shopby\Model\Source
 */
class SubmitMode implements \Magento\Framework\Option\ArrayInterface
{
    const INSTANTLY = 0;

    const BY_BUTTON_CLICK = 1;

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [];
        foreach ($this->toArray() as $optionValue => $optionLabel) {
            $options[] = [
                'value' => $optionValue,
                'label' => $optionLabel
            ];
        }

        return $options;
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            self::INSTANTLY => __('Instantly'),
            self::BY_BUTTON_CLICK => __('By Button Click')
        ];
    }
}
