<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2021 Amasty (https://www.amasty.com)
 * @package Amasty_Xlanding
 */


declare(strict_types=1);

namespace Amasty\Xlanding\Model\ResourceModel;

use Amasty\Base\Model\MagentoVersion;
use Amasty\Xlanding\Api\Data\PageInterface;
use Amasty\Xlanding\Model\Indexer\IndexBuilder;
use Magento\Catalog\Model\ResourceModel\Product\Collection as ProductCollection;
use Magento\Framework\DB\Select;

class AddPositionIndexJoin
{
    const POSITION_COLUMN_NAME = 'cat_index_position';
    const COLUMN_NAME_INDEX = 2;

    /**
     * @var MagentoVersion
     */
    private $magentoVersion;

    public function __construct(
        MagentoVersion $magentoVersion
    ) {
        $this->magentoVersion = $magentoVersion;
    }

    public function execute(ProductCollection $collection, PageInterface $page)
    {
        /**
         * @var Select $select
         */
        $select = $collection->getSelect();
        $columns = $select->getPart(Select::COLUMNS);

        foreach ($columns as $index => $column) {
            if (isset($column[self::COLUMN_NAME_INDEX])
                && $column[self::COLUMN_NAME_INDEX] == self::POSITION_COLUMN_NAME
            ) {
                unset($columns[$index]);
                break;
            }
        }
        $select->setPart(Select::COLUMNS, $columns);
        $table = IndexBuilder::TABLE_NAME;

        if (version_compare($this->magentoVersion->get(), '2.3.2', '>=')) {
            $positionExpr = new \Zend_Db_Expr("IFNULL(page_product_index.position, 0)");
        } else {
            $positionExpr = new \Zend_Db_Expr("IFNULL(page_product_index.position, cat_index.position)");
        }

        $select->joinInner(
            ['page_product_index' => $collection->getResource()->getTable($table)],
            'page_product_index.product_id = e.entity_id'
            . ' AND page_product_index.page_id = ' . $page->getId()
            . ' AND page_product_index.store_id = ' . $collection->getStoreId(),
            ['cat_index_position' => $positionExpr]
        );
    }
}
