<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2021 Amasty (https://www.amasty.com)
 * @package Amasty_Xlanding
 */


declare(strict_types=1);

namespace Amasty\Xlanding\Plugin\Catalogsearch\Model\ResourceModel\Fulltext;

use Amasty\Xlanding\Api\Data\PageInterface;
use Amasty\Xlanding\Model\ConfigProvider;
use Amasty\Xlanding\Model\ResourceModel\AddPositionIndexJoin;
use Magento\Eav\Model\Entity\Collection\AbstractCollection;
use Magento\Framework\Registry;

class Collection
{
    /**
     * @var Registry
     */
    private $coreRegistry;

    /**
     * @var bool
     */
    private $isPositionIndexJoinApplied = false;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var AddPositionIndexJoin
     */
    private $addPositionIndexJoin;

    public function __construct(
        Registry $coreRegistry,
        ConfigProvider $configProvider,
        AddPositionIndexJoin $addPositionIndexJoin
    ) {
        $this->coreRegistry = $coreRegistry;
        $this->configProvider = $configProvider;
        $this->addPositionIndexJoin = $addPositionIndexJoin;
    }

    /**
     * @param $collection
     * @return mixed
     */
    public function afterAddCategoryFilter($collection)
    {
        if ($page = $this->coreRegistry->registry('amasty_xlanding_page')) {
            $this->addPositionIndexJoin($collection);
        }

        return $collection;
    }

    /**
     * @param $collection
     * @return $this
     */
    private function addPositionIndexJoin($collection)
    {
        if (!$this->isPositionIndexJoinApplied) {
            $page = $this->coreRegistry->registry('amasty_xlanding_page');

            if ($page instanceof PageInterface) {
                $this->addPositionIndexJoin->execute($collection, $page);
            }

            $this->isPositionIndexJoinApplied = true;
        }

        return $this;
    }

    /**
     * @param $collection
     * @param callable $proceed
     * @param $attribute
     * @param $dir
     * @return mixed
     */
    public function aroundAddAttributeToSort(
        $collection,
        callable $proceed,
        $attribute,
        $dir = AbstractCollection::SORT_ORDER_ASC
    ) {
        $result = $this->addAttributeToSort($collection, $attribute, $dir);

        return $result ?: $proceed($attribute, $dir);
    }

    public function addAttributeToSort($collection, string $attribute, string $dir)
    {
        if ($this->coreRegistry->registry('amasty_xlanding_page')
            && $attribute == 'position'
            && !$this->configProvider->isElasticSearchEnabled()
        ) {
            $this->addPositionIndexJoin($collection);
            $collection->getSelect()->order('cat_index_position ' . $dir);
            return $collection;
        }

        return null;
    }
}
