<?php

namespace Atrato\PayLater\Block;

use Atrato\PayLater\Helper\Data;
use Atrato\PayLater\Model\Config\Settings;
use Magento\Framework\View\Element\Template;
use Magento\Store\Model\StoreManagerInterface;
use \Magento\Catalog\Model\ProductRepository;


class AtratoConfigurationLabel extends Template
{
    /**
     * @var Settings
     */
    public $Settings;
    /**
     * @var Data
     */
    public $Data;
    /**
     * @var \Magento\Catalog\Model\ProductRepository
     */
    /**
     * @var \Magento\Catalog\Model\ProductRepository
     */
    protected $productRepository;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param Template\Context $context
     * @param ProductRepository $productRepository
     * @param Settings $Settings
     * @param StoreManagerInterface $storeManager
     * @param Data $Data
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        ProductRepository $productRepository,
        Settings $Settings,
        StoreManagerInterface $storeManager,
        Data $Data,
        array $data = []
    ) {
        $this->Settings = $Settings;
        $this->productRepository = $productRepository;
        $this->storeManager = $storeManager;
        $this->Data = $Data;
        parent::__construct($context, $data);
    }

    /**
     * @param $id
     * @return \Magento\Catalog\Api\Data\ProductInterface|mixed|null
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getPrice($id)
    {
        return $this->productRepository->getById($id)->getPrice();
    }

    /**
     * @return Settings
     */
    public function getSettings()
    {
        return $this->Settings;
    }

    /**
     * @return string|null
     */
    public function getStoreCode()
    {
        try {
            $store = $this->storeManager->getStore();
            return $store->getCode();
        } catch (\Magento\Framework\Exception\NoSuchEntityException $e) {
            return null;
        }
    }

    /**
     * @return Data
     */
    public function getDataHelper()
    {
        return $this->Data;
    }
}
