<?php

namespace Atrato\PayLater\Block;

use Atrato\PayLater\Model\Config\Settings;
use Magento\Customer\Model\Session;
use Magento\Framework\View\Element\Template;
use Magento\Quote\Model\QuoteIdMaskFactory;
use Magento\Sales\Model\Order;

class AtratoConfigurationSuccess extends Template
{
    /**
     * @var Order
     */
    private $order;
    /**
     * @var Settings
     */
    private $settings;
    /**
     * @var Session
     */
    private $session;
    /**
     * @var QuoteIdMaskFactory
     */
    private $quoteFactory;

    /**
     * @param Template\Context $context
     * @param Order $order
     * @param Settings $settings
     * @param Session $session
     * @param QuoteIdMaskFactory $quoteFactory
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        Order $order,
        Settings $settings,
        Session $session,
        QuoteIdMaskFactory $quoteFactory,
        array $data = []
    ) {
        $this->order = $order;
        $this->settings = $settings;
        $this->session = $session;
        $this->quoteFactory = $quoteFactory;
        parent::__construct($context, $data);
    }

    /**
     * @param $orderId
     * @return Order
     */
    public function getOrder($orderId)
    {
        return $this->order->loadByIncrementId($orderId);
    }

    /**
     * @return Settings
     */
    public function getAtratoSettings()
    {
        return $this->settings;
    }

    /**
     * @return Session
     */
    public function getCustomerSession()
    {
        return $this->session;
    }

    /**
     * @param $quoteId
     * @return string
     */
    public function getMaskedId($quoteId)
    {
        return  $this->quoteFactory->create()->load($quoteId, 'quote_id')->getMaskedId();
    }
}
