<?php

namespace Atrato\PayLater\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Checkout\Model\Session;
use \Magento\Framework\App\Request\Http;
use \Magento\Framework\View\Page\Config;
use \Magento\Framework\View\Result\Page;


class CustomSuccessPage extends AbstractHelper
{
    protected $_request;
    protected $checkoutSession;
    protected $_pageConfig;
    protected $_resultPage;

    public function __construct(
        Http $request,
        Session $session,
        Config $pageConfig,
        Page $resultPage
    ) {
        $this->_request = $request;
        $this->checkoutSession = $session;
        $this->_pageConfig  = $pageConfig;
        $this->_resultPage  = $resultPage;
    }

    public function getTemplate()
    {
        $payment = $this->checkoutSession->getLastRealOrder()->getPayment()->getMethodInstance()->getCode();
        if ($payment == 'atrato_paylater') {
            $template =  'Atrato_PayLater::order/success.phtml';

            $pageMainTitle =  $this->_resultPage->getLayout()->getBlock('page.main.title');
            if ($pageMainTitle) {
                $pageMainTitle->setPageTitle(__('Tu orden ha sido recibida.'));
            }
        } else {
            $template = 'Magento_Checkout::success.phtml';
        }

        return $template;
    }
}
