<?php

namespace Atrato\PayLater\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

class Data extends AbstractHelper
{
    const XML_PATH_ATRATO_PAYLATER = 'payment/';

    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field,
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }

    public function getGeneralConfig($code, $storeId = null, $group = 'atrato_paylater/')
    {
        return $this->getConfigValue(self::XML_PATH_ATRATO_PAYLATER . $group . $code, $storeId);
    }
}
