<?php

namespace Atrato\PayLater\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class PaymentMethodAvailable implements ObserverInterface
{
   protected $_customerSession;
   protected $_cart;
   protected $_atratoConfig;

   public function __construct(\Atrato\PayLater\Model\Config\Settings $atratoConfig, \Magento\Customer\Model\Session $customerSession, \Magento\Checkout\Model\Cart $cart)
   {
      $this->_customerSession = $customerSession;
      $this->_cart = $cart;
      $this->_atratoConfig = $atratoConfig;
   }

   public function execute(Observer $observer)
   {
      $payment_method_code = $observer->getEvent()->getMethodInstance()->getCode();
      // Detectar método de pago de atrato
      if ($payment_method_code == 'atrato_paylater') {
         $result = $observer->getEvent()->getResult();
         $method_instance = $observer->getEvent()->getMethodInstance();
         $quote = $this->_cart->getQuote();
         $grandTotal = $quote->getGrandTotal();

         \Magento\Framework\App\ObjectManager::getInstance()->get('Psr\Log\LoggerInterface')
            ->debug('grandTotal', array('subTotal' => $this->_atratoConfig->getMinimumAmount()));


         // Validar si el monto del carrito esté dentro del rango, sinó deshabilitar.
         if ($grandTotal < $this->_atratoConfig->getMinimumAmount() || $grandTotal > $this->_atratoConfig->getMaximumAmount()) {

            $result->setData('is_available', false);
         }

         // \Magento\Framework\App\ObjectManager::getInstance()->get('Psr\Log\LoggerInterface')
         //                  ->debug('grandTotal', array('subTotal'=> $grandTotal));

      }
   }
}
