<?php

namespace Atrato\PayLater\Setup;

use Magento\Framework\Exception\AlreadyExistsException;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;


use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\StatusFactory;
use Magento\Sales\Model\ResourceModel\Order\StatusFactory as StatusResourceFactory;

class InstallData implements InstallDataInterface
{
    const ORDER_STATUS_PENDING_APPROVAL_ATRATO_CODE = "pending_atrato";
    const ORDER_STATUS_PENDING_APPROVAL_ATRATO_LABEL = "Esperando Aprobación de Atrato";

    const ORDER_STATUS_DISBURSED_ATRATO_CODE = "disbursed_atrato";
    const ORDER_STATUS_DISBURSED_ATRATO_LABEL = "Crédito Desembolsado por Atrato";

    const ORDER_STATUS_SIGNED_CONTRACT_ATRATO_CODE = "signed_atrato";
    const ORDER_STATUS_SIGNED_CONTRACT_ATRATO_LABEL = "Crédito Autorizado por Atrato";

    const ORDER_STATUS_DISBURSED_PENDING_ATRATO_CODE="disbursed_pending_atrato";
    const ORDER_STATUS_DISBURSED_PENDING_ATRATO_LABEL ="Crédito Autorizado por Atrato (Pendiente Desembolso)";

    const ORDER_STATUS_CANCELLED_ATRATO_CODE = "canceled_atrato";
    const ORDER_STATUS_CANCELLED_ATRATO_LABEL = "Solicitud Cancelada por Atrato";

    protected  $statusFactory;
    protected  $statusResourceFactory;


    public function __construct(
        StatusFactory $statusFactory,
        StatusResourceFactory $statusResourceFactory
    ) {
        $this->statusFactory = $statusFactory;
        $this->statusResourceFactory = $statusResourceFactory;
    }


    /**
     * Installs data for a module
     *
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $this->DisburseAtratoInstall();
        $this->CancelledAtratoInstall();
        $this->PendingAtratoInstall();
        $this->SignedAtratoInstall();
        $this->SignedAtratoPendingInstall();
        $setup->endSetup();
    }

    private function PendingAtratoInstall()
    {
        $statusResource = $this->statusResourceFactory->create();
        $status = $this->statusFactory->create();
        $status->setData([
            'status' => self::ORDER_STATUS_PENDING_APPROVAL_ATRATO_CODE,
            'label' => self::ORDER_STATUS_PENDING_APPROVAL_ATRATO_LABEL,
        ]);
        try {
            $statusResource->save($status);
        } catch (AlreadyExistsException $exception) {
            return;
        }
        $status->assignState(Order::STATE_PENDING_PAYMENT, false, true);
    }

    private function CancelledAtratoInstall()
    {
        $statusResource = $this->statusResourceFactory->create();
        $status = $this->statusFactory->create();
        $status->setData([
            'status' => self::ORDER_STATUS_CANCELLED_ATRATO_CODE,
            'label' => self::ORDER_STATUS_CANCELLED_ATRATO_LABEL,
        ]);
        try {
            $statusResource->save($status);
        } catch (AlreadyExistsException $exception) {
            return;
        }
        $status->assignState(Order::STATE_CANCELED, false, true);
    }

    private function DisburseAtratoInstall()
    {
        $statusResource = $this->statusResourceFactory->create();
        $status = $this->statusFactory->create();
        $status->setData([
            'status' => self::ORDER_STATUS_DISBURSED_ATRATO_CODE,
            'label' => self::ORDER_STATUS_DISBURSED_ATRATO_LABEL,
        ]);
        try {
            $statusResource->save($status);
        } catch (AlreadyExistsException $exception) {
            return;
        }
        $status->assignState(Order::STATE_PROCESSING, false, true);
    }

    private function SignedAtratoInstall()
    {
        $statusResource = $this->statusResourceFactory->create();
        $status = $this->statusFactory->create();
        $status->setData([
            'status' => self::ORDER_STATUS_SIGNED_CONTRACT_ATRATO_CODE,
            'label' => self::ORDER_STATUS_SIGNED_CONTRACT_ATRATO_LABEL,
        ]);
        try {
            $statusResource->save($status);
        } catch (AlreadyExistsException $exception) {
            return;
        }

        $status->assignState(Order::STATE_PROCESSING, false, true);
    }
    private function SignedAtratoPendingInstall()
    {
        $statusResource = $this->statusResourceFactory->create();
        $status = $this->statusFactory->create();
        $status->setData([
            'status' => self::ORDER_STATUS_DISBURSED_PENDING_ATRATO_CODE,
            'label' => self::ORDER_STATUS_DISBURSED_PENDING_ATRATO_LABEL,
        ]);
        try {
            $statusResource->save($status);
        } catch (AlreadyExistsException $exception) {
            return;
        }

        $status->assignState(Order::STATE_PENDING_PAYMENT, false, true);
    }
}
