define([
  "Magento_Checkout/js/view/payment/default",
  "Magento_Checkout/js/model/quote",
  "Magento_Ui/js/model/messageList",
  "mage/translate",
], function (Component, quote, messageList, translate) {
  "use strict";
  return Component.extend({
    defaults: {
      template: "Atrato_PayLater/payment/payment_template",
    },
    getRenderUrlAtratoPaymetCheckout: function () {
      var totalsQuote = quote.getTotals()();
      var shippingAddress = quote.shippingAddress();

      const idCommerce =
        window.checkoutConfig.payment.atrato_paylater.partnerkey;
      const urlBaseAtrato =
        window.checkoutConfig.payment.atrato_paylater.urlbaseatrato;

      const quoteId = quote.getQuoteId();
      const grand_total = totalsQuote.grand_total;
      const customer_email = quote.guestEmail
        ? quote.guestEmail
        : window.checkoutConfig.quoteData.customer_email;
      const customer_firstname = shippingAddress.firstname;
      const customer_lastname = shippingAddress.lastname;
      const customer_telephone = shippingAddress.telephone;
      let customer_products = "";
      quote.getItems().forEach((element) => {
        customer_products += `${element.product.sku}-${element.name},`;
      });

      const modelToUrl = {
        orderNumber: "QUOTE",
        orderId: quoteId,
        idCommerce: idCommerce,
        product: customer_products,
        price: grand_total ? grand_total.toString() : "0",
        name: `${customer_firstname} ${customer_lastname}`,
        email: customer_email,
        phone: customer_telephone ? customer_telephone.replace("+52", "") : "",
        plataform: "magento",
      };
      const paramsJSON = JSON.stringify(modelToUrl);
      const paramsb46 = window.btoa(unescape(encodeURIComponent(paramsJSON)));
      const hrefUrl = `${urlBaseAtrato}/ecommerce/checkout?order=${paramsb46}&version=2`;
      return hrefUrl;
    },
    isQuoteComplete: function () {
      jQuery("body").trigger("processStart");
      const idCommerce =
        window.checkoutConfig.payment.atrato_paylater.partnerkey;
      const quoteId = window.checkoutConfig.quoteData.entity_id;
      const encodedString = window.checkoutConfig.payment.atrato_paylater.id;
      const urlApiatrato =
        window.checkoutConfig.payment.atrato_paylater.urlapiatrato;

      var requestOptions = {
        method: "GET",
        redirect: "follow",
      };

      fetch(
        `${urlApiatrato}/ecommerce/magento/v2/quote/${quoteId}/${encodedString}/${idCommerce}/completed`,
        requestOptions
      )
        .then((response) => response.text())
        .then((result) => {
          jQuery("body").trigger("processStop");
          const objResult = JSON.parse(result);
          if (objResult.success) {
            if (objResult.step.status === "complete") {
              document.getElementById("data-button-atrato-place-order").click();
              messageList.addSuccessMessage({
                message: translate("Se ha generado la solicitud!."),
              });
            }

            if (objResult.step.status === "pending") {
              setTimeout(function () {
                messageList.addSuccessMessage({
                  message: translate(
                    "Tienes una solicitud pendiente de terminar, para completar el proceso da click en Atrato pago."
                  ),
                });
              }, 5000);
            }

            if (objResult.step.status === "rejected") {
              messageList.addErrorMessage({
                message: translate(
                  "Lo sentimos tu solicitud con Atrato ha sido rechazada."
                ),
              });
            }
          } else {
            setTimeout(function () {
              messageList.addSuccessMessage({
                message: translate(
                  "Continua con tu proceso de solicitud con Atrato, para completar el proceso."
                ),
              });
            }, 5000);
          }
        })
        .catch((error) => {
          jQuery("body").trigger("processStop");
          setTimeout(function () {
            messageList.addSuccessMessage({
              message: translate(
                "Continua con tu proceso de solicitud, para completar el proceso."
              ),
            });
          }, 5000);
        });
    },
  });
});
