<?php
/**
 * @author Cartin24 Team
 * @copyright Copyright (c) 2016 Cartin24 (http://www.cartin24.com)
 * @package Cartin24_Productqa
 */
namespace Cartin24\Productqa\Block\Adminhtml\Productqa\Edit;

use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Registry;
use Magento\Framework\Data\FormFactory;
use Magento\Cms\Model\Wysiwyg\Config;

/**
 * Adminhtml item edit form
 */
class Form extends \Magento\Backend\Block\Widget\Form\Generic
{
    /**
     * @var \Magento\Cms\Model\Wysiwyg\Config
     */
    protected $_wysiwygConfig;

    /**
     * @var \Magento\Store\Model\System\Store
     */
    protected $_systemStore;
    protected $helper;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Data\FormFactory $formFactory
     * @param \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig
     * @param \Magento\Store\Model\System\Store $systemStore
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig,
        \Magento\Store\Model\System\Store $systemStore,\Cartin24\Productqa\Helper\Data $helper,
        array $data = []
    ) {
        $this->_wysiwygConfig = $wysiwygConfig;
        $this->_systemStore = $systemStore;
        $this->helper = $helper;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Init form
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('question_form');
        $this->setTitle(__('Item Information'));
    }

    /**
     * Prepare form
     *
     * @return $this
     */
    protected function _prepareForm()
    {
        $model = $this->_coreRegistry->registry('question_item');

        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create(
            ['data' => ['id' => 'edit_form', 'action' => $this->getData('action'), 'method' => 'post']]
        );

        $form->setHtmlIdPrefix('item_');

        $fieldset = $form->addFieldset(
            'base_fieldset',
            ['legend' => null,  'class' => 'fieldset-wide']
        );
        
        if ($model->getId()) {
			
            $fieldset->addField('question_id', 'hidden', ['name' => 'question_id']);
            $fieldset->addField(
            'product_name',
            'text',
            [
                'name' => 'product_name',
                'label' => __('Product Name/SKU'),
                'title' => __('Product Name/SKU'),
                'readonly' => true,
                
            ]
        );
        
        }else{
			$fieldset->addField(
				'product_id',
				'select',
				[
					'name' => 'product_id',
					'label' => __('Product'),
					'title' => __('Product'),
					'required' => true,
					'options'  =>  $this->helper->getOptionArray(),
					'onchange' => "document.getElementById('item_product_name').value = jQuery('select option:selected').text();"
				]
			);
			$fieldset->addField('product_name', 'hidden', ['name' => 'product_name']);
	}
        $fieldset->addField(
            'name',
            'text',
            [
                'name' => 'name',
                'label' => __('Name'),
                'title' => __('Name'),
                'required' => true
            ]
        );

        $fieldset->addField(
            'email',
            'text',
            [
                'name' => 'email',
                'label' => __('Email'),
                'title' => __('Email'),
                'required' => true,
                'class' => 'validate-email'
            ]
        );
          $fieldset->addField(
            'subject',
            'text',
            [
                'name' => 'subject',
                'label' => __('Subject'),
                'title' => __('Subject'),
              //  'required' => true,
            ]
        );
          $fieldset->addField(
            'question',
            'textarea',
            [
                'name' => 'question',
                'label' => __('Question'),
                'title' => __('Question'),
                'required' => true,
            ]
        );
         $wysiwygConfig = $this->_wysiwygConfig->getConfig();
         $fieldset->addField(
            'answer',
            'editor',
            [
                'name' => 'answer',
                'label' => __('Answer'),
                'title' => __('Answer'),
                'required' => true,
                'config'   => $wysiwygConfig,
            ]
        );
        if ($model->getCustomerNotified()) {
			 $fieldset->addField(
            'customer_notified',
            'hidden',
            [
                'name' => 'customer_notified',
                'label' => __('Customer Notification email was sent'),
                'title' => __('Customer Notification email was sent'),
            ]
        );
		}else{
		$fieldset->addField(
            'customer_notify',
            'checkbox',
            [
                'name' => 'customer_notify',
                'label' => __('Notify customer by Email'),
                'title' => __('Notify customer by Email'),
                'required' => false,
                'onchange' => "if(this.checked){document.getElementById('item_customer_notified').value = 1;}else{document.getElementById('item_customer_notified').value = 0;}"
            ]
        );
        $fieldset->addField(
            'customer_notified',
            'hidden',
            [
                'name' => 'customer_notified',
                'value' =>'0'

            ]
        );
		}
        $fieldset->addField(
            'is_active',
            'select',
            [
                'label' => __('Display in Frontend'),
                'title' => __('Display in Frontend'),
                'name' => 'is_active',
                'required' => true,
                'options' => ['1' => __('Yes'), '0' => __('No')]
            ]
        );
        
        if (!$model->getId()) {
            $model->setData('is_active', '1');
        }
        
        $values = $model->getData();
        
        if($model->getId()){
			$values['product_name'] =  $this->helper->getProductName($model->getProductId());
        }
        $form->setValues($values);
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
    
}
