<?php 
/**
 * @author Cartin24 Team
 * @copyright Copyright (c) 2016 Cartin24 (http://www.cartin24.com)
 * @package Cartin24_Productqa
 */

namespace Cartin24\Productqa\Block;

use \Magento\Framework\View\Element\Template;


class Productqa extends Template
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;   
    protected $qaCollectionFactory;
    protected $filterProvider;
    protected $coreRegistry ;
    protected $_customerSession ;
	
	/**
     * @param Template\Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param array $data
     */
      
    public function __construct(Template\Context $context,\Cartin24\Productqa\Model\ResourceModel\Productqa\CollectionFactory $qaCollectionFactory,
    \Magento\Cms\Model\Template\FilterProvider $filterProvider,\Magento\Framework\Registry $registry, \Magento\Customer\Model\Session $customerSession,  array $data = [])
    {
		$this->scopeConfig = $context->getScopeConfig();		
		$this->qaCollectionFactory = $qaCollectionFactory;
		$this->filterProvider = $filterProvider;
		$this->coreRegistry = $registry;
		$this->_customerSession = $customerSession;
		parent::__construct($context, $data);
    }
  
	/**
     * Retrieve Form Title
     *
     * @return String
     */
    public function getFormTitle()
    {
		
		$title = $this->scopeConfig->getValue('cartin24_productqa/general/heading',\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		if(! $title)
			$title = "Do you have any question?";
        return $title;
    }
    public function getTitle()
    {
		
		$title = $this->scopeConfig->getValue('cartin24_productqa/general/title',\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		if(! $title)
			$title = "Frequently Asked Questions";
        return $title;
    }
    
    public function getFormAction()
    {
		return $this->getUrl('productqa/qa/post');
    }
    
    public function showSubjectField()
    {		
		$val = $this->scopeConfig->getValue('cartin24_productqa/general/show_subject',\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		return $val;
    }
    public function addCaptcha()
    {		
		$val = $this->scopeConfig->getValue('cartin24_productqa/general/captcha',\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		return $val;
    }
    
    public function getFaq()
    {		
		 $collection = $this->qaCollectionFactory->create()	
				->addFilter('product_id', $this->getProductId())					
                ->addFilter('is_active', 1);
      	 return $collection;
    }
    public function showTime(){
		
		$val = $this->scopeConfig->getValue('cartin24_productqa/general/show_date',\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		return $val;	
	}
	
	public function getFilterProvider()
    {				
      	 return $this->filterProvider;
    }
    
    public function getProductId()
    {				
      	 return $this->coreRegistry->registry('current_product')->getId();
    }
     public function getProductName()
    {				
      	 return $this->coreRegistry->registry('current_product')->getName();
    }
     /**
     * Retrieve form data
     *
     * @return mixed
     */
    public function getFormData()
    {
		$formData = $this->_session->getQaFormData(true);
		$data = new \Magento\Framework\DataObject();
		if ($formData) {
			$data->addData($formData);
		}else{
			if($this->_customerSession->isLoggedIn()) {
			   $formData['name'] = $this->_customerSession->getCustomer()->getName();
			   $formData['email'] = $this->_customerSession->getCustomer()->getEmail();
			   $data->addData($formData);
			}
		}          
		         
		$this->setData('form_data', $data);        
        return $data;
    }
}
