<?php
/**
 * @author Cartin24 Team
 * @copyright Copyright (c) 2016 Cartin24 (http://www.cartin24.com)
 * @package Cartin24_Productqa
 */
namespace Cartin24\Productqa\Controller\Adminhtml\Productqa;


class Save extends \Cartin24\Productqa\Controller\Adminhtml\Productqa
{
   const XML_PATH_CUSTOMER_EMAIL_TEMPLATE_FIELD  = 'cartin24_productqa/general/qa_email_template';
   
    protected $_filterProvider;
    protected $_qaModel;
    protected $_emailHelper;
    protected $_productModel;
    
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Cms\Model\Template\FilterProvider $filterProvider,
        \Cartin24\Productqa\Model\Productqa $qaModel,
        \Cartin24\Productqa\Helper\Email $helper,
        \Magento\Catalog\Model\Product $product

    ) {
		$this->_filterProvider = $filterProvider;
		$this->_qaModel = $qaModel;
		$this->_emailHelper = $helper;
		$this->_productModel = $product;
        
        parent::__construct($context,$registry);
    }
    /**
     * Save action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();
        if ($data) {
            $id = $this->getRequest()->getParam('question_id');
            $model = $this->_qaModel->load($id);
            
            if (!$model->getId() && $id) {
                $this->messageManager->addError(__('This item no longer exists.'));
                return $resultRedirect->setPath('*/*/');
            }
			if($data['answer'])
				$data['status'] = 1;
	    $notificationStatus = $model->getCustomerNotified();
	    $productId = $model->getProductId();    	
	
            $model->setData($data);

            try {		
                if(($data['customer_notified']) && ( $notificationStatus != 1) ){
					$receiverInfo = [
							'name' => $model->getName(),
							'email' =>  $model->getEmail()
						];
						
						 						

						$emailTemplateVariables = array();
						$emailTempVariables['subject'] = $model->getSubject();
						$emailTempVariables['question'] = $model->getQuestion();
						$product = $this->_productModel->load($productId);	
						//$emailTempVariables['answer'] = $this->_filterProvider->getPageFilter()-> filter($model->getAnswer());
						$emailTempVariables['answer'] = $product->getProductUrl().'?answer='.$id.'#id-'.$id;

						$emailTempVariables['productName'] = $data['product_name'];
						$emailTempVariables['name'] = $model->getName();
						$templateId = self::XML_PATH_CUSTOMER_EMAIL_TEMPLATE_FIELD;
						$this->_emailHelper->customMailSend(
							  $emailTempVariables,
							  $receiverInfo,
							  $templateId 
						  );
			
			}
			$model->save();

                $this->messageManager->addSuccess(__('You saved the item.'));
                $this->_objectManager->get('Magento\Backend\Model\Session')->setFormData(false);

                if ($this->getRequest()->getParam('back')) {
                    return $resultRedirect->setPath('*/*/edit', ['question_id' => $model->getId()]);
                }
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                $this->_objectManager->get('Magento\Backend\Model\Session')->setFormData($data);
                return $resultRedirect->setPath('*/*/edit', ['question_id' => $this->getRequest()->getParam('question_id')]);
            }
        }
        return $resultRedirect->setPath('*/*/');
    }
}
