<?php
/**
 * @author Cartin24 Team
 * @copyright Copyright (c) 2016 Cartin24 (http://www.cartin24.com)
 * @package Cartin24_Productqa
 */
 
namespace Cartin24\Productqa\Controller\Qa;

use Magento\Framework\App\Action\Context;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\Controller\ResultFactory; 


class Post extends \Magento\Framework\App\Action\Action
{
  const XML_PATH_ADMIN_EMAIL_TEMPLATE_FIELD  = 'cartin24_productqa/general/qa_adminemail_template';
  
  protected $resultPageFactory;
  protected $_productloader; 
  protected $scopeConfig;
  protected $_emailHelper;
  protected $_qaModel;

  
  
  
  public function __construct(
		\Magento\Framework\App\Action\Context $context,
		\Magento\Catalog\Model\ProductFactory $_productloader,
		\Magento\Framework\View\Result\PageFactory $resultPageFactory,
		\Cartin24\Productqa\Helper\Email $helper,
		\Cartin24\Productqa\Model\Productqa $qaModel,
		\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig

	)
  {
	$this->scopeConfig = $scopeConfig;	
  	$this->_productloader = $_productloader;
  	$this->_qaModel = $qaModel;
    	$this->_emailHelper = $helper;
   	parent::__construct($context);
	
  }

  public function execute()
  {
    $post = $this->getRequest()->getPostValue();
	if (!$post) {
		$this->_redirect('*/*/');
		return;
	}
	
	try{	
		 $question = $this->_qaModel;
		 $question->setData($post);
		 $question->save();
		 $enable = $this->scopeConfig->getValue('cartin24_productqa/general/enable_email',\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		 $email = $this->scopeConfig->getValue('cartin24_productqa/general/email',\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		 if(($enable == 1) && ($email != '')){
			 $receiverInfo = [
					'name' => 'Admin',
					'email' => $email
					];
						
						 						

			$emailTemplateVariables = array();
			$emailTempVariables['subject'] = $question->getSubject();
			$emailTempVariables['question'] = $question->getQuestion();
			$emailTempVariables['custemail'] = $question->getEmail();
			$emailTempVariables['productName'] = $post['product_name'];
			$emailTempVariables['name'] = $question->getName();
			$templateId = self::XML_PATH_ADMIN_EMAIL_TEMPLATE_FIELD;		
			$this->_emailHelper->customMailSend(
				  $emailTempVariables,
				  $receiverInfo,
				  $templateId 
			  );
		 }
		 $this->messageManager->addSuccess(__('Successfully submitted your question.'));
	
	}catch (\Exception $e) {
		$this->messageManager->addError(__('We can’t process your request right now. Sorry, that’s all we know.')	);
	}
	$resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
    $resultRedirect->setUrl($this->_redirect->getRefererUrl());

    return $resultRedirect;
  }
	
}
