<?php 
/**
 * @author Cartin24 Team
 * @copyright Copyright (c) 2016 Cartin24 (http://www.cartin24.com)
 * @package Cartin24_Productqa
 */

namespace Cartin24\Productqa\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    protected $productcollection ;
    protected $catalogProductVisibility ;
    protected $_productRepository;
    
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productcollection,
        \Magento\Catalog\Model\Product\Visibility $catalogProductVisibility,
        \Magento\Catalog\Model\ProductRepository $productRepository
    )
    {
		$this->_productcollection = $productcollection;
		$this->_productRepository = $productRepository;
        $this->_catalogProductVisibility = $catalogProductVisibility;
        parent::__construct($context);
    }

    public function getOptionArray()
    {
		$collection =  $this->_productcollection->create()->addAttributeToSelect('name')
                        ->addAttributeToFilter('status', '1');
        $collection->setVisibility($this->_catalogProductVisibility->getVisibleInCatalogIds());	
        $options = array('' =>__('Please Select'));
        foreach($collection as $col){
			
			$options[$col->getId()] = $col->getName();
			
		}
		return $options;
    }
     public function getProductName($id)
    {
		$product = $this->_productRepository->getById($id);
		return $product->getName().' / '. $product->getSku();
    }
 
}
