<?php 
/**
 * @author Cartin24 Team
 * @copyright Copyright (c) 2016 Cartin24 (http://www.cartin24.com)
 * @package Cartin24_Productqa
 */
 
namespace Cartin24\Productqa\Model;

class Productqa extends \Magento\Framework\Model\AbstractModel
{
    /**
     * Statuses
     */
    const STATUS_ENABLED = 1;
    const STATUS_DISABLED = 0;

    /**
     * Aion Test cache tag
     */
    const CACHE_TAG = 'cartin24_productqa';

    /**
     * @var string
     */
    protected $_cacheTag = 'cartin24_productqa';

    /**
     * Prefix of model events names
     *
     * @var string
     */
    protected $_eventPrefix = 'cartin24_productqa';

    /**
     * @return void
     */
    protected function _construct()
    {
        $this->_init('Cartin24\Productqa\Model\ResourceModel\Productqa');
    }

    /**
     * Get identities
     *
     * @return array
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId(), self::CACHE_TAG . '_' . $this->getId()];
    }

   

}
