<?php 
/**
 * @author Cartin24 Team
 * @copyright Copyright (c) 2016 Cartin24 (http://www.cartin24.com)
 * @package Cartin24_Productqa
 */
namespace Cartin24\Productqa\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Captcha\Observer\CaptchaStringResolver;
use Magento\Framework\ObjectManagerInterface;

class CheckQaFormObserver implements ObserverInterface
{
    /**
     * @var \Magento\Captcha\Helper\Data
     */
    protected $_helper;

    /**
     * @var \Magento\Framework\App\ActionFlag
     */
    protected $_actionFlag;

    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    protected $messageManager;

	/**
     * @var \Magento\Framework\Session\SessionManagerInterface
     */
    protected $_session;
    
    /**
     * @var \Magento\Framework\App\Response\RedirectInterface
     */
    protected $redirect;

    /**
     * @var CaptchaStringResolver
     */
    protected $captchaStringResolver;

    /**
     * @var DataPersistorInterface
     */
    private $dataPersistor;

	 /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
     protected $scopeConfig;
	
     protected $_objectManager;
     
     protected $_productModel;
	
    /**
     * @param \Magento\Captcha\Helper\Data $helper
     * @param \Magento\Framework\App\ActionFlag $actionFlag
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     * @param \Magento\Framework\App\Response\RedirectInterface $redirect
     * @param CaptchaStringResolver $captchaStringResolver
     */
    public function __construct(
        \Magento\Captcha\Helper\Data $helper,
        \Magento\Framework\App\ActionFlag $actionFlag,
        \Magento\Framework\Message\ManagerInterface $messageManager,
         \Magento\Framework\Session\SessionManagerInterface $session,
        \Magento\Framework\App\Response\RedirectInterface $redirect,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Catalog\Model\Product $product,
        ObjectManagerInterface $objectManager,
        CaptchaStringResolver $captchaStringResolver
    ) {
        $this->_helper = $helper;
        $this->_actionFlag = $actionFlag;
        $this->messageManager = $messageManager;
        $this->_session = $session;
        $this->redirect = $redirect;
        $this->captchaStringResolver = $captchaStringResolver;
        $this->scopeConfig = $scopeConfig;	
        $this->_objectManager = $objectManager;
        $this->_productModel = $product;
    }

    /**
     * Check CAPTCHA on QA Form
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $formId = 'productqa_form';
        $captcha = $this->_helper->getCaptcha($formId);
        $captchaEnabled = $this->scopeConfig->getValue('cartin24_productqa/general/captcha',\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		
        if (($captcha->isRequired()) && ($captchaEnabled)) {
            /** @var \Magento\Framework\App\Action\Action $controller */
            $controller = $observer->getControllerAction();
            if (!$captcha->isCorrect($this->captchaStringResolver->resolve($controller->getRequest(), $formId))) {
                $this->messageManager->addError(__('Incorrect CAPTCHA.'));
                $this->_session->setQaFormData($controller->getRequest()->getPostValue());
                $this->_actionFlag->set('', \Magento\Framework\App\Action\Action::FLAG_NO_DISPATCH, true); 
                               
				$post = $controller->getRequest()->getPostValue();
				$product = $this->_productModel->load($post['product_id']);
				$url = $product->getProductUrl();
                $controller->getResponse()->setRedirect($this->redirect->error($url));
                
            }
        }
    }

   
}
