<?php
/**
 * @author Cartin24 Team
 * @copyright Copyright (c) 2016 Cartin24 (http://www.cartin24.com)
 * @package Cartin24_Productqa
 */

namespace Cartin24\Productqa\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;


class UpgradeSchema implements UpgradeSchemaInterface
{
     public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
				
        $setup->startSetup();
        $tableName = $setup->getTable('cartin24_productqa');
        if (version_compare($context->getVersion(), '1.0.1') < 0) {
       
              if ($setup->getConnection()->isTableExists($tableName) == true) {
					
					$connection = $setup->getConnection();      
									
					$fullTextIntex = array('subject', 'name', 'email');  
					$connection->addIndex(
						$tableName,
						$setup->getIdxName($tableName, $fullTextIntex, \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT),
						$fullTextIntex,
						\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
					);                 
                
            
			}

		}
        $setup->endSetup();

    }
}
