<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\SeoBase\Model\ResourceModel\Catalog\Product;

use Magento\CatalogUrlRewrite\Model\ProductUrlRewriteGenerator;
use MageWorx\SeoBase\Model\Source\CanonicalType;


class XmlSitemapModifier extends \MageWorx\SeoBase\Model\ResourceModel\Catalog\Product
{
    /**
     * @var \MageWorx\SeoBase\Helper\Data
     */
    protected $helperData;

    /**
     * @var \MageWorx\SeoBase\Model\ResourceModel\Catalog\Product\FlexibleCanonical
     */
    protected $flexibleCanonicalResource;

    /**
     * CrossDomain constructor.
     *
     * @param \Magento\Framework\Model\ResourceModel\Db\Context $context
     * @param \MageWorx\SeoBase\Helper\Data $helperData
     * @param \Magento\Catalog\Model\ResourceModel\Product $productResource
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Catalog\Model\Product\Visibility $productVisibility
     * @param \Magento\Catalog\Model\Product\Attribute\Source\Status $productStatus
     * @param \Magento\Eav\Model\ConfigFactory $eavConfigFactory
     * @param \MageWorx\SeoBase\Helper\StoreUrl $helperStoreUrl
     * @param \Magento\Framework\DataObject\Factory $objectFactory
     * @param \MageWorx\SeoAll\Helper\LinkFieldResolver $linkFieldResolver
     * @param FlexibleCanonical $flexibleCanonical
     * @param null $resourcePrefix
     */
    public function __construct(
        \Magento\Framework\Model\ResourceModel\Db\Context $context,
        \MageWorx\SeoBase\Helper\Data $helperData,
        \Magento\Catalog\Model\ResourceModel\Product $productResource,
        \MageWorx\SeoAll\Helper\LinkFieldResolver $linkFieldResolver,
        \MageWorx\SeoBase\Model\ResourceModel\Catalog\Product\FlexibleCanonical $flexibleCanonical,
        $resourcePrefix = null
    ) {
        $this->helperData                = $helperData;
        $this->flexibleCanonicalResource = $flexibleCanonical;

        parent::__construct($context, $productResource, $linkFieldResolver, $resourcePrefix);
    }

    /**
     * @param \Magento\Framework\DB\Select $select
     * @param int $storeId
     */
    public function modify($select, $storeId)
    {
        $subQueryCondition = $this->getUrlRewriteSubQueryCondition($storeId);
        $subQuery          = $this->getUrlRewriteSubQuery($storeId);

        if ($subQuery && $subQueryCondition) {
            $select
                ->where($subQueryCondition, $subQuery)
                ->group('e.entity_id');
        } else {
            $select
                ->where('url_rewrite.metadata IS NULL');
        }
    }

    /**
     * @param int $storeId
     * @return \Zend_Db_Expr|null
     */
    protected function getUrlRewriteSubQueryCondition($storeId)
    {
        $urlType = $this->helperData->getProductCanonicalUrlType($storeId);

        if ($urlType !== CanonicalType::URL_TYPE_NO_CATEGORIES) {
            return new \Zend_Db_Expr('`url_rewrite`.`request_path` = ? OR `url_rewrite`.`request_path` IS NULL');
        }

        return null;
    }

    /**
     * @param int $storeId
     * @return \Magento\Framework\DB\Select|null
     */
    protected function getUrlRewriteSubQuery($storeId)
    {
        $urlType = $this->helperData->getProductCanonicalUrlType($storeId);

        if (CanonicalType::URL_TYPE_NO_CATEGORIES === $urlType) {
            return null;
        }

        $select = $this->getConnection()->select();
        $select->from(
            ['url_b' => $this->getTable('url_rewrite')],
            ['url_b.request_path']
        )
               ->where('url_b.entity_type = ?', ProductUrlRewriteGenerator::ENTITY_TYPE)
               ->where('url_b.store_id = ?', (int)$storeId)
               ->where('url_b.entity_id = url_rewrite.entity_id')
               ->where('url_b.is_autogenerated = 1');

        $this->flexibleCanonicalResource->addFlexibleConditions($select, $storeId, 'url_b');

        return $select;
    }
}