<?php
/**
 * Copyright © 2016 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */
namespace MageWorx\SeoBase\Model\Source;

class Country extends \MageWorx\SeoBase\Model\Source
{
    /**
     * ISO 639-1
     * @var array
     */
    protected $options = [
            ['value' => 'AF', 'label' => 'Afghanistan (AF)'],
            ['value' => 'AL', 'label' => 'Albania (AL)'],
            ['value' => 'DZ', 'label' => 'Algeria (DZ)'],
            ['value' => 'AD', 'label' => 'Andorra (AD)'],
            ['value' => 'AO', 'label' => 'Angola (AO)'],
            ['value' => 'AG', 'label' => 'Antigua and Barbuda (AG)'],
            ['value' => 'AR', 'label' => 'Argentina (AR)'],
            ['value' => 'AM', 'label' => 'Armenia (AM)'],
            ['value' => 'AU', 'label' => 'Australia (AU)'],
            ['value' => 'AT', 'label' => 'Austria (AT)'],
            ['value' => 'AZ', 'label' => 'Azerbaijan (AZ)'],
            ['value' => 'BS', 'label' => 'Bahamas, The (BS)'],
            ['value' => 'BH', 'label' => 'Bahrain (BH)'],
            ['value' => 'BD', 'label' => 'Bangladesh (BD)'],
            ['value' => 'BB', 'label' => 'Barbados (BB)'],
            ['value' => 'BY', 'label' => 'Belarus (BY)'],
            ['value' => 'BE', 'label' => 'Belgium (BE)'],
            ['value' => 'BZ', 'label' => 'Belize (BZ)'],
            ['value' => 'BJ', 'label' => 'Benin (BJ)'],
            ['value' => 'BT', 'label' => 'Bhutan (BT)'],
            ['value' => 'BO', 'label' => 'Bolivia (BO)'],
            ['value' => 'BA', 'label' => 'Bosnia and Herzegovina (BA)'],
            ['value' => 'BW', 'label' => 'Botswana (BW)'],
            ['value' => 'BR', 'label' => 'Brazil (BR)'],
            ['value' => 'BN', 'label' => 'Brunei (BN)'],
            ['value' => 'BG', 'label' => 'Bulgaria (BG)'],
            ['value' => 'BF', 'label' => 'Burkina Faso (BF)'],
            ['value' => 'BI', 'label' => 'Burundi (BI)'],
            ['value' => 'KH', 'label' => 'Cambodia (KH)'],
            ['value' => 'CM', 'label' => 'Cameroon (CM)'],
            ['value' => 'CA', 'label' => 'Canada (CA)'],
            ['value' => 'CV', 'label' => 'Cape Verde (CV)'],
            ['value' => 'CF', 'label' => 'Central African Republic (CF)'],
            ['value' => 'TD', 'label' => 'Chad (TD)'],
            ['value' => 'CL', 'label' => 'Chile (CL)'],
            ['value' => 'CN', 'label' => 'China, People\'s Republic of (CN)'],
            ['value' => 'CO', 'label' => 'Colombia (CO)'],
            ['value' => 'KM', 'label' => 'Comoros (KM)'],
            ['value' => 'CD', 'label' => 'Congo, (Congo Â– Kinshasa) (CD)'],
            ['value' => 'CG', 'label' => 'Congo, (Congo Â– Brazzaville) (CG)'],
            ['value' => 'CR', 'label' => 'Costa Rica (CR)'],
            ['value' => 'CI', 'label' => 'Cote d\'Ivoire (Ivory Coast) (CI)'],
            ['value' => 'HR', 'label' => 'Croatia (HR)'],
            ['value' => 'CU', 'label' => 'Cuba (CU)'],
            ['value' => 'CY', 'label' => 'Cyprus (CY)'],
            ['value' => 'CZ', 'label' => 'Czech Republic (CZ)'],
            ['value' => 'DK', 'label' => 'Denmark (DK)'],
            ['value' => 'DJ', 'label' => 'Djibouti (DJ)'],
            ['value' => 'DM', 'label' => 'Dominica (DM)'],
            ['value' => 'DO', 'label' => 'Dominican Republic (DO)'],
            ['value' => 'EC', 'label' => 'Ecuador (EC)'],
            ['value' => 'EG', 'label' => 'Egypt (EG)'],
            ['value' => 'SV', 'label' => 'El Salvador (SV)'],
            ['value' => 'GQ', 'label' => 'Equatorial Guinea (GQ)'],
            ['value' => 'ER', 'label' => 'Eritrea (ER)'],
            ['value' => 'EE', 'label' => 'Estonia (EE)'],
            ['value' => 'ET', 'label' => 'Ethiopia (ET)'],
            ['value' => 'FJ', 'label' => 'Fiji (FJ)'],
            ['value' => 'FI', 'label' => 'Finland (FI)'],
            ['value' => 'FR', 'label' => 'France (FR)'],
            ['value' => 'GA', 'label' => 'Gabon (GA)'],
            ['value' => 'GM', 'label' => 'Gambia, The (GM)'],
            ['value' => 'GE', 'label' => 'Georgia (GE)'],
            ['value' => 'DE', 'label' => 'Germany (DE)'],
            ['value' => 'GH', 'label' => 'Ghana (GH)'],
            ['value' => 'GR', 'label' => 'Greece (GR)'],
            ['value' => 'GD', 'label' => 'Grenada (GD)'],
            ['value' => 'GT', 'label' => 'Guatemala (GT)'],
            ['value' => 'GN', 'label' => 'Guinea (GN)'],
            ['value' => 'GW', 'label' => 'Guinea-Bissau (GW)'],
            ['value' => 'GY', 'label' => 'Guyana (GY)'],
            ['value' => 'HT', 'label' => 'Haiti (HT)'],
            ['value' => 'HN', 'label' => 'Honduras (HN)'],
            ['value' => 'HU', 'label' => 'Hungary (HU)'],
            ['value' => 'IS', 'label' => 'Iceland (IS)'],
            ['value' => 'IN', 'label' => 'India (IN)'],
            ['value' => 'ID', 'label' => 'Indonesia (ID)'],
            ['value' => 'IR', 'label' => 'Iran (IR)'],
            ['value' => 'IQ', 'label' => 'Iraq (IQ)'],
            ['value' => 'IE', 'label' => 'Ireland (IE)'],
            ['value' => 'IL', 'label' => 'Israel (IL)'],
            ['value' => 'IT', 'label' => 'Italy (IT)'],
            ['value' => 'JM', 'label' => 'Jamaica (JM)'],
            ['value' => 'JP', 'label' => 'Japan (JP)'],
            ['value' => 'JO', 'label' => 'Jordan (JO)'],
            ['value' => 'KZ', 'label' => 'Kazakhstan (KZ)'],
            ['value' => 'KE', 'label' => 'Kenya (KE)'],
            ['value' => 'KI', 'label' => 'Kiribati (KI)'],
            ['value' => 'KP', 'label' => 'Korea, North (KP)'],
            ['value' => 'KR', 'label' => 'Korea, South (KR)'],
            ['value' => 'KW', 'label' => 'Kuwait (KW)'],
            ['value' => 'KG', 'label' => 'Kyrgyzstan (KG)'],
            ['value' => 'LA', 'label' => 'Laos (LA)'],
            ['value' => 'LV', 'label' => 'Latvia (LV)'],
            ['value' => 'LB', 'label' => 'Lebanon (LB)'],
            ['value' => 'LS', 'label' => 'Lesotho (LS)'],
            ['value' => 'LR', 'label' => 'Liberia (LR)'],
            ['value' => 'LY', 'label' => 'Libya (LY)'],
            ['value' => 'LI', 'label' => 'Liechtenstein (LI)'],
            ['value' => 'LT', 'label' => 'Lithuania (LT)'],
            ['value' => 'LU', 'label' => 'Luxembourg (LU)'],
            ['value' => 'MK', 'label' => 'Macedonia (MK)'],
            ['value' => 'MG', 'label' => 'Madagascar (MG)'],
            ['value' => 'MW', 'label' => 'Malawi (MW)'],
            ['value' => 'MY', 'label' => 'Malaysia (MY)'],
            ['value' => 'MV', 'label' => 'Maldives (MV)'],
            ['value' => 'ML', 'label' => 'Mali (ML)'],
            ['value' => 'MT', 'label' => 'Malta (MT)'],
            ['value' => 'MH', 'label' => 'Marshall Islands (MH)'],
            ['value' => 'MR', 'label' => 'Mauritania (MR)'],
            ['value' => 'MU', 'label' => 'Mauritius (MU)'],
            ['value' => 'MX', 'label' => 'Mexico (MX)'],
            ['value' => 'FM', 'label' => 'Micronesia (FM)'],
            ['value' => 'MD', 'label' => 'Moldova (MD)'],
            ['value' => 'MC', 'label' => 'Monaco (MC)'],
            ['value' => 'MN', 'label' => 'Mongolia (MN)'],
            ['value' => 'ME', 'label' => 'Montenegro (ME)'],
            ['value' => 'MA', 'label' => 'Morocco (MA)'],
            ['value' => 'MZ', 'label' => 'Mozambique (MZ)'],
            ['value' => 'MM', 'label' => 'Myanmar (Burma) (MM)'],
            ['value' => 'NA', 'label' => 'Namibia (NA)'],
            ['value' => 'NR', 'label' => 'Nauru (NR)'],
            ['value' => 'NP', 'label' => 'Nepal (NP)'],
            ['value' => 'NL', 'label' => 'Netherlands (NL)'],
            ['value' => 'NZ', 'label' => 'New Zealand (NZ)'],
            ['value' => 'NI', 'label' => 'Nicaragua (NI)'],
            ['value' => 'NE', 'label' => 'Niger (NE)'],
            ['value' => 'NG', 'label' => 'Nigeria (NG)'],
            ['value' => 'NO', 'label' => 'Norway (NO)'],
            ['value' => 'OM', 'label' => 'Oman (OM)'],
            ['value' => 'PK', 'label' => 'Pakistan (PK)'],
            ['value' => 'PW', 'label' => 'Palau (PW)'],
            ['value' => 'PA', 'label' => 'Panama (PA)'],
            ['value' => 'PG', 'label' => 'Papua New Guinea (PG)'],
            ['value' => 'PY', 'label' => 'Paraguay (PY)'],
            ['value' => 'PE', 'label' => 'Peru (PE)'],
            ['value' => 'PH', 'label' => 'Philippines (PH)'],
            ['value' => 'PL', 'label' => 'Poland (PL)'],
            ['value' => 'PT', 'label' => 'Portugal (PT)'],
            ['value' => 'QA', 'label' => 'Qatar (QA)'],
            ['value' => 'RO', 'label' => 'Romania (RO)'],
            ['value' => 'RU', 'label' => 'Russia (RU)'],
            ['value' => 'RW', 'label' => 'Rwanda (RW)'],
            ['value' => 'KN', 'label' => 'Saint Kitts and Nevis (KN)'],
            ['value' => 'LC', 'label' => 'Saint Lucia (LC)'],
            ['value' => 'VC', 'label' => 'Saint Vincent and the Grenadines (VC)'],
            ['value' => 'WS', 'label' => 'Samoa (WS)'],
            ['value' => 'SM', 'label' => 'San Marino (SM)'],
            ['value' => 'ST', 'label' => 'Sao Tome and Principe (ST)'],
            ['value' => 'SA', 'label' => 'Saudi Arabia (SA)'],
            ['value' => 'SN', 'label' => 'Senegal (SN)'],
            ['value' => 'RS', 'label' => 'Serbia (RS)'],
            ['value' => 'SC', 'label' => 'Seychelles (SC)'],
            ['value' => 'SL', 'label' => 'Sierra Leone (SL)'],
            ['value' => 'SG', 'label' => 'Singapore (SG)'],
            ['value' => 'SK', 'label' => 'Slovakia (SK)'],
            ['value' => 'SI', 'label' => 'Slovenia (SI)'],
            ['value' => 'SB', 'label' => 'Solomon Islands (SB)'],
            ['value' => 'SO', 'label' => 'Somalia (SO)'],
            ['value' => 'ZA', 'label' => 'South Africa (ZA)'],
            ['value' => 'ES', 'label' => 'Spain (ES)'],
            ['value' => 'LK', 'label' => 'Sri Lanka (LK)'],
            ['value' => 'SD', 'label' => 'Sudan (SD)'],
            ['value' => 'SR', 'label' => 'Suriname (SR)'],
            ['value' => 'SZ', 'label' => 'Swaziland (SZ)'],
            ['value' => 'SE', 'label' => 'Sweden (SE)'],
            ['value' => 'CH', 'label' => 'Switzerland (CH)'],
            ['value' => 'SY', 'label' => 'Syria (SY)'],
            ['value' => 'TJ', 'label' => 'Tajikistan (TJ)'],
            ['value' => 'TZ', 'label' => 'Tanzania (TZ)'],
            ['value' => 'TH', 'label' => 'Thailand (TH)'],
            ['value' => 'TL', 'label' => 'Timor-Leste (East Timor) (TL)'],
            ['value' => 'TG', 'label' => 'Togo (TG)'],
            ['value' => 'TO', 'label' => 'Tonga (TO)'],
            ['value' => 'TT', 'label' => 'Trinidad and Tobago (TT)'],
            ['value' => 'TN', 'label' => 'Tunisia (TN)'],
            ['value' => 'TR', 'label' => 'Turkey (TR)'],
            ['value' => 'TM', 'label' => 'Turkmenistan (TM)'],
            ['value' => 'TV', 'label' => 'Tuvalu (TV)'],
            ['value' => 'UG', 'label' => 'Uganda (UG)'],
            ['value' => 'UA', 'label' => 'Ukraine (UA)'],
            ['value' => 'AE', 'label' => 'United Arab Emirates (AE)'],
            ['value' => 'GB', 'label' => 'United Kingdom (GB)'],
            ['value' => 'US', 'label' => 'United States (US)'],
            ['value' => 'UY', 'label' => 'Uruguay (UY)'],
            ['value' => 'UZ', 'label' => 'Uzbekistan (UZ)'],
            ['value' => 'VU', 'label' => 'Vanuatu (VU)'],
            ['value' => 'VA', 'label' => 'Vatican City (VA)'],
            ['value' => 'VE', 'label' => 'Venezuela (VE)'],
            ['value' => 'VN', 'label' => 'Vietnam (VN)'],
            ['value' => 'YE', 'label' => 'Yemen (YE)'],
            ['value' => 'ZM', 'label' => 'Zambia (ZM)'],
            ['value' => 'ZW', 'label' => 'Zimbabwe (ZW)'],
            ['value' => 'GE', 'label' => 'Abkhazia (GE)'],
            ['value' => 'TW', 'label' => 'China, Republic of (Taiwan) (TW)'],
            ['value' => 'AZ', 'label' => 'Nagorno-Karabakh (AZ)'],
            ['value' => 'CY', 'label' => 'Northern Cyprus (CY)'],
            ['value' => 'MD', 'label' => 'Pridnestrovie (Transnistria) (MD)'],
            ['value' => 'SO', 'label' => 'Somaliland (SO)'],
            ['value' => 'GE', 'label' => 'South Ossetia (GE)'],
            ['value' => 'AU', 'label' => 'Ashmore and Cartier Islands (AU)'],
            ['value' => 'CX', 'label' => 'Christmas Island (CX)'],
            ['value' => 'CC', 'label' => 'Cocos (Keeling) Islands (CC)'],
            ['value' => 'AU', 'label' => 'Coral Sea Islands (AU)'],
            ['value' => 'HM', 'label' => 'Heard Island and McDonald Islands (HM)'],
            ['value' => 'NF', 'label' => 'Norfolk Island (NF)'],
            ['value' => 'NC', 'label' => 'New Caledonia (NC)'],
            ['value' => 'PF', 'label' => 'French Polynesia (PF)'],
            ['value' => 'YT', 'label' => 'Mayotte (YT)'],
            ['value' => 'GP', 'label' => 'Saint Barthelemy (GP)'],
            ['value' => 'GP', 'label' => 'Saint Martin (GP)'],
            ['value' => 'PM', 'label' => 'Saint Pierre and Miquelon (PM)'],
            ['value' => 'WF', 'label' => 'Wallis and Futuna (WF)'],
            ['value' => 'TF', 'label' => 'French Southern and Antarctic Lands (TF)'],
            ['value' => 'PF', 'label' => 'Clipperton Island (PF)'],
            ['value' => 'BV', 'label' => 'Bouvet Island (BV)'],
            ['value' => 'CK', 'label' => 'Cook Islands (CK)'],
            ['value' => 'NU', 'label' => 'Niue (NU)'],
            ['value' => 'TK', 'label' => 'Tokelau (TK)'],
            ['value' => 'GG', 'label' => 'Guernsey (GG)'],
            ['value' => 'IM', 'label' => 'Isle of Man (IM)'],
            ['value' => 'JE', 'label' => 'Jersey (JE)'],
            ['value' => 'AI', 'label' => 'Anguilla (AI)'],
            ['value' => 'BM', 'label' => 'Bermuda (BM)'],
            ['value' => 'IO', 'label' => 'British Indian Ocean Territory (IO)'],
            ['value' => 'VG', 'label' => 'British Virgin Islands (VG)'],
            ['value' => 'KY', 'label' => 'Cayman Islands (KY)'],
            ['value' => 'FK', 'label' => 'Falkland Islands (Islas Malvinas) (FK)'],
            ['value' => 'GI', 'label' => 'Gibraltar (GI)'],
            ['value' => 'MS', 'label' => 'Montserrat (MS)'],
            ['value' => 'PN', 'label' => 'Pitcairn Islands (PN)'],
            ['value' => 'SH', 'label' => 'Saint Helena (SH)'],
            ['value' => 'GS', 'label' => 'South Georgia & South Sandwich Islands (GS)'],
            ['value' => 'TC', 'label' => 'Turks and Caicos Islands (TC)'],
            ['value' => 'MP', 'label' => 'Northern Mariana Islands (MP)'],
            ['value' => 'PR', 'label' => 'Puerto Rico (PR)'],
            ['value' => 'AS', 'label' => 'American Samoa (AS)'],
            ['value' => 'UM', 'label' => 'Baker Island (UM)'],
            ['value' => 'GU', 'label' => 'Guam (GU)'],
            ['value' => 'UM', 'label' => 'Howland Island (UM)'],
            ['value' => 'UM', 'label' => 'Jarvis Island (UM)'],
            ['value' => 'UM', 'label' => 'Johnston Atoll (UM)'],
            ['value' => 'UM', 'label' => 'Kingman Reef (UM)'],
            ['value' => 'UM', 'label' => 'Midway Islands (UM)'],
            ['value' => 'UM', 'label' => 'Navassa Island (UM)'],
            ['value' => 'UM', 'label' => 'Palmyra Atoll (UM)'],
            ['value' => 'VI', 'label' => 'U.S. Virgin Islands (VI)'],
            ['value' => 'UM', 'label' => 'Wake Island (UM)'],
            ['value' => 'HK', 'label' => 'Hong Kong (HK)'],
            ['value' => 'MO', 'label' => 'Macau (MO)'],
            ['value' => 'FO', 'label' => 'Faroe Islands (FO)'],
            ['value' => 'GL', 'label' => 'Greenland (GL)'],
            ['value' => 'GF', 'label' => 'French Guiana (GF)'],
            ['value' => 'GP', 'label' => 'Guadeloupe (GP)'],
            ['value' => 'MQ', 'label' => 'Martinique (MQ)'],
            ['value' => 'RE', 'label' => 'Reunion (RE)'],
            ['value' => 'AX', 'label' => 'Aland (AX)'],
            ['value' => 'AW', 'label' => 'Aruba (AW)'],
            ['value' => 'AN', 'label' => 'Netherlands Antilles (AN)'],
            ['value' => 'SJ', 'label' => 'Svalbard (SJ)'],
            ['value' => 'AC', 'label' => 'Ascension (AC)'],
            ['value' => 'TA', 'label' => 'Tristan da Cunha (TA)'],
            ['value' => 'AQ', 'label' => 'Australian Antarctic Territory (AQ)'],
            ['value' => 'AQ', 'label' => 'Ross Dependency (AQ)'],
            ['value' => 'AQ', 'label' => 'Peter I Island (AQ)'],
            ['value' => 'AQ', 'label' => 'Queen Maud Land (AQ)'],
            ['value' => 'AQ', 'label' => 'British Antarctic Territory (AQ)']
    ];

    public function toOptionArray()
    {
        return $this->options;
    }
}
