<?php
/**
 * Copyright © 2016 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */
namespace MageWorx\SeoBase\Model\Source;

class Locale extends \MageWorx\SeoBase\Model\Source
{
    /**
     * ISO 639-1
     * @var array
     */
    protected $options = [
            ['value' => 'ab', 'label' => 'Abkhaz (ab)'],
            ['value' => 'aa', 'label' => 'Afar (aa)'],
            ['value' => 'af', 'label' => 'Afrikaans (af)'],
            ['value' => 'ak', 'label' => 'Akan (ak)'],
            ['value' => 'sq', 'label' => 'Albanian (sq)'],
            ['value' => 'am', 'label' => 'Amharic (am)'],
            ['value' => 'ar', 'label' => 'Arabic (ar)'],
            ['value' => 'an', 'label' => 'Aragonese (an)'],
            ['value' => 'hy', 'label' => 'Armenian (hy)'],
            ['value' => 'as', 'label' => 'Assamese (as)'],
            ['value' => 'av', 'label' => 'Avaric (av)'],
            ['value' => 'ae', 'label' => 'Avestan (ae)'],
            ['value' => 'ay', 'label' => 'Aymara (ay)'],
            ['value' => 'az', 'label' => 'Azerbaijani (az)'],
            ['value' => 'bm', 'label' => 'Bambara (bm)'],
            ['value' => 'ba', 'label' => 'Bashkir (ba)'],
            ['value' => 'eu', 'label' => 'Basque (eu)'],
            ['value' => 'be', 'label' => 'Belarusian (be)'],
            ['value' => 'bn', 'label' => 'Bengali, Bangla (bn)'],
            ['value' => 'bh', 'label' => 'Bihari (bh)'],
            ['value' => 'bi', 'label' => 'Bislama (bi)'],
            ['value' => 'bs', 'label' => 'Bosnian (bs)'],
            ['value' => 'br', 'label' => 'Breton (br)'],
            ['value' => 'bg', 'label' => 'Bulgarian (bg)'],
            ['value' => 'my', 'label' => 'Burmese (my)'],
            ['value' => 'ca', 'label' => 'Catalan (ca)'],
            ['value' => 'ch', 'label' => 'Chamorro (ch)'],
            ['value' => 'ce', 'label' => 'Chechen (ce)'],
            ['value' => 'ny', 'label' => 'Chichewa, Chewa, Nyanja (ny)'],
            ['value' => 'zh', 'label' => 'Chinese (zh)'],
            ['value' => 'cv', 'label' => 'Chuvash (cv)'],
            ['value' => 'kw', 'label' => 'Cornish (kw)'],
            ['value' => 'co', 'label' => 'Corsican (co)'],
            ['value' => 'cr', 'label' => 'Cree (cr)'],
            ['value' => 'hr', 'label' => 'Croatian (hr)'],
            ['value' => 'cs', 'label' => 'Czech (cs)'],
            ['value' => 'da', 'label' => 'Danish (da)'],
            ['value' => 'dv', 'label' => 'Divehi, Dhivehi, Maldivian (dv)'],
            ['value' => 'nl', 'label' => 'Dutch (nl)'],
            ['value' => 'dz', 'label' => 'Dzongkha (dz)'],
            ['value' => 'en', 'label' => 'English (en)'],
            ['value' => 'eo', 'label' => 'Esperanto (eo)'],
            ['value' => 'et', 'label' => 'Estonian (et)'],
            ['value' => 'ee', 'label' => 'Ewe (ee)'],
            ['value' => 'fo', 'label' => 'Faroese (fo)'],
            ['value' => 'fj', 'label' => 'Fijian (fj)'],
            ['value' => 'fi', 'label' => 'Finnish (fi)'],
            ['value' => 'fr', 'label' => 'French (fr)'],
            ['value' => 'ff', 'label' => 'Fula, Fulah, Pulaar, Pular (ff)'],
            ['value' => 'gl', 'label' => 'Galician (gl)'],
            ['value' => 'ka', 'label' => 'Georgian (ka)'],
            ['value' => 'de', 'label' => 'German (de)'],
            ['value' => 'el', 'label' => 'Greek (modern) (el)'],
            ['value' => 'gn', 'label' => 'Guaraní (gn)'],
            ['value' => 'gu', 'label' => 'Gujarati (gu)'],
            ['value' => 'ht', 'label' => 'Haitian, Haitian Creole (ht)'],
            ['value' => 'ha', 'label' => 'Hausa (ha)'],
            ['value' => 'he', 'label' => 'Hebrew  (he)'],
            ['value' => 'hz', 'label' => 'Herero (hz)'],
            ['value' => 'hi', 'label' => 'Hindi (hi)'],
            ['value' => 'ho', 'label' => 'Hiri Motu (ho)'],
            ['value' => 'hu', 'label' => 'Hungarian (hu)'],
            ['value' => 'ia', 'label' => 'Interlingua (ia)'],
            ['value' => 'id', 'label' => 'Indonesian (id)'],
            ['value' => 'ie', 'label' => 'Interlingue (ie)'],
            ['value' => 'ga', 'label' => 'Irish (ga)'],
            ['value' => 'ig', 'label' => 'Igbo (ig)'],
            ['value' => 'ik', 'label' => 'Inupiaq (ik)'],
            ['value' => 'io', 'label' => 'Ido (io)'],
            ['value' => 'is', 'label' => 'Icelandic (is)'],
            ['value' => 'it', 'label' => 'Italian (it)'],
            ['value' => 'iu', 'label' => 'Inuktitut (iu)'],
            ['value' => 'ja', 'label' => 'Japanese (ja)'],
            ['value' => 'jv', 'label' => 'Javanese (jv)'],
            ['value' => 'kl', 'label' => 'Kalaallisut, Greenlandic (kl)'],
            ['value' => 'kn', 'label' => 'Kannada (kn)'],
            ['value' => 'kr', 'label' => 'Kanuri (kr)'],
            ['value' => 'ks', 'label' => 'Kashmiri (ks)'],
            ['value' => 'kk', 'label' => 'Kazakh (kk)'],
            ['value' => 'km', 'label' => 'Khmer (km)'],
            ['value' => 'ki', 'label' => 'Kikuyu, Gikuyu (ki)'],
            ['value' => 'rw', 'label' => 'Kinyarwanda (rw)'],
            ['value' => 'ky', 'label' => 'Kyrgyz (ky)'],
            ['value' => 'kv', 'label' => 'Komi (kv)'],
            ['value' => 'kg', 'label' => 'Kongo (kg)'],
            ['value' => 'ko', 'label' => 'Korean (ko)'],
            ['value' => 'ku', 'label' => 'Kurdish (ku)'],
            ['value' => 'kj', 'label' => 'Kwanyama, Kuanyama (kj)'],
            ['value' => 'la', 'label' => 'Latin (la)'],
            ['value' => 'lb', 'label' => 'Luxembourgish, Letzeburgesch (lb)'],
            ['value' => 'lg', 'label' => 'Ganda (lg)'],
            ['value' => 'li', 'label' => 'Limburgish, Limburgan, Limburger (li)'],
            ['value' => 'ln', 'label' => 'Lingala (ln)'],
            ['value' => 'lo', 'label' => 'Lao (lo)'],
            ['value' => 'lt', 'label' => 'Lithuanian (lt)'],
            ['value' => 'lu', 'label' => 'Luba-Katanga (lu)'],
            ['value' => 'lv', 'label' => 'Latvian (lv)'],
            ['value' => 'gv', 'label' => 'Manx (gv)'],
            ['value' => 'mk', 'label' => 'Macedonian (mk)'],
            ['value' => 'mg', 'label' => 'Malagasy (mg)'],
            ['value' => 'ms', 'label' => 'Malay (ms)'],
            ['value' => 'ml', 'label' => 'Malayalam (ml)'],
            ['value' => 'mt', 'label' => 'Maltese (mt)'],
            ['value' => 'mi', 'label' => 'Māori (mi)'],
            ['value' => 'mr', 'label' => 'Marathi  (mr)'],
            ['value' => 'mh', 'label' => 'Marshallese (mh)'],
            ['value' => 'mn', 'label' => 'Mongolian (mn)'],
            ['value' => 'na', 'label' => 'Nauru (na)'],
            ['value' => 'nv', 'label' => 'Navajo, Navaho (nv)'],
            ['value' => 'nd', 'label' => 'Northern Ndebele (nd)'],
            ['value' => 'ne', 'label' => 'Nepali (ne)'],
            ['value' => 'ng', 'label' => 'Ndonga (ng)'],
            ['value' => 'nb', 'label' => 'Norwegian Bokmål (nb)'],
            ['value' => 'nn', 'label' => 'Norwegian Nynorsk (nn)'],
            ['value' => 'no', 'label' => 'Norwegian (no)'],
            ['value' => 'ii', 'label' => 'Nuosu (ii)'],
            ['value' => 'nr', 'label' => 'Southern Ndebele (nr)'],
            ['value' => 'oc', 'label' => 'Occitan (oc)'],
            ['value' => 'oj', 'label' => 'Ojibwe, Ojibwa (oj)'],
            ['value' => 'cu', 'label' => 'Old Church Slavonic, Old Bulgarian (cu)'],
            ['value' => 'om', 'label' => 'Oromo (om)'],
            ['value' => 'or', 'label' => 'Oriya (or)'],
            ['value' => 'os', 'label' => 'Ossetian, Ossetic (os)'],
            ['value' => 'pa', 'label' => 'Panjabi, Punjabi (pa)'],
            ['value' => 'pi', 'label' => 'Pāli (pi)'],
            ['value' => 'fa', 'label' => 'Persian (Farsi) (fa)'],
            ['value' => 'pl', 'label' => 'Polish (pl)'],
            ['value' => 'ps', 'label' => 'Pashto, Pushto (ps)'],
            ['value' => 'pt', 'label' => 'Portuguese (pt)'],
            ['value' => 'qu', 'label' => 'Quechua (qu)'],
            ['value' => 'rm', 'label' => 'Romansh (rm)'],
            ['value' => 'rn', 'label' => 'Kirundi (rn)'],
            ['value' => 'ro', 'label' => 'Romanian (ro)'],
            ['value' => 'ru', 'label' => 'Russian (ru)'],
            ['value' => 'sa', 'label' => 'Sanskrit  (sa)'],
            ['value' => 'sc', 'label' => 'Sardinian (sc)'],
            ['value' => 'sd', 'label' => 'Sindhi (sd)'],
            ['value' => 'se', 'label' => 'Northern Sami (se)'],
            ['value' => 'sm', 'label' => 'Samoan (sm)'],
            ['value' => 'sg', 'label' => 'Sango (sg)'],
            ['value' => 'sk', 'label' => 'Saraiki,Seraiki,Siraiki (sk)'],
            ['value' => 'sr', 'label' => 'Serbian (sr)'],
            ['value' => 'gd', 'label' => 'Scottish Gaelic, Gaelic (gd)'],
            ['value' => 'sn', 'label' => 'Shona (sn)'],
            ['value' => 'si', 'label' => 'Sinhala (si)'],
            ['value' => 'sk', 'label' => 'Slovak (sk)'],
            ['value' => 'sl', 'label' => 'Slovene (sl)'],
            ['value' => 'so', 'label' => 'Somali (so)'],
            ['value' => 'st', 'label' => 'Southern Sotho (st)'],
            ['value' => 'es', 'label' => 'Spanish (es)'],
            ['value' => 'su', 'label' => 'Sundanese (su)'],
            ['value' => 'sw', 'label' => 'Swahili (sw)'],
            ['value' => 'ss', 'label' => 'Swati (ss)'],
            ['value' => 'sv', 'label' => 'Swedish (sv)'],
            ['value' => 'ta', 'label' => 'Tamil (ta)'],
            ['value' => 'te', 'label' => 'Telugu (te)'],
            ['value' => 'tg', 'label' => 'Tajik (tg)'],
            ['value' => 'th', 'label' => 'Thai (th)'],
            ['value' => 'ti', 'label' => 'Tigrinya (ti)'],
            ['value' => 'bo', 'label' => 'Tibetan (bo)'],
            ['value' => 'tk', 'label' => 'Turkmen (tk)'],
            ['value' => 'tl', 'label' => 'Tagalog (tl)'],
            ['value' => 'tn', 'label' => 'Tswana (tn)'],
            ['value' => 'to', 'label' => 'Tonga  (to)'],
            ['value' => 'tr', 'label' => 'Turkish (tr)'],
            ['value' => 'ts', 'label' => 'Tsonga (ts)'],
            ['value' => 'tt', 'label' => 'Tatar (tt)'],
            ['value' => 'tw', 'label' => 'Twi (tw)'],
            ['value' => 'ty', 'label' => 'Tahitian (ty)'],
            ['value' => 'ug', 'label' => 'Uyghur (ug)'],
            ['value' => 'uk', 'label' => 'Ukrainian (uk)'],
            ['value' => 'ur', 'label' => 'Urdu (ur)'],
            ['value' => 'uz', 'label' => 'Uzbek (uz)'],
            ['value' => 've', 'label' => 'Venda (ve)'],
            ['value' => 'vi', 'label' => 'Vietnamese (vi)'],
            ['value' => 'vo', 'label' => 'Volapük (vo)'],
            ['value' => 'wa', 'label' => 'Walloon (wa)'],
            ['value' => 'cy', 'label' => 'Welsh (cy)'],
            ['value' => 'wo', 'label' => 'Wolof (wo)'],
            ['value' => 'fy', 'label' => 'Western Frisian (fy)'],
            ['value' => 'xh', 'label' => 'Xhosa (xh)'],
            ['value' => 'yi', 'label' => 'Yiddish (yi)'],
            ['value' => 'yo', 'label' => 'Yoruba (yo)'],
            ['value' => 'za', 'label' => 'Zhuang, Chuang (za)'],
            ['value' => 'zu', 'label' => 'Zulu (zu)'],
            ['value' => 'zh-Hans', 'label' => 'Chinese simplified (zh-Hans)'],
            ['value' => 'zh-Hant', 'label' => 'Chinese traditional (zh-Hant)']
    ];

    public function toOptionArray()
    {
        return $this->options;
    }
}
