<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

declare(strict_types=1);

namespace MageWorx\SeoBase\Model\System\Config\Backend;

use Magento\Config\Model\Config\Backend\Serialized;
use MageWorx\SeoBase\Model\HreflangsConfigReader;

class HreflangSettings extends Serialized
{
    /**
     * @return Serialized
     */
    public function beforeSave()
    {
        $value = $this->getValue();

        if (is_array($value)) {
            $this->setValue($this->prepareValue($value));
        }

        return parent::beforeSave();
    }

    /**
     * @param array $value
     * @return array
     */
    protected function prepareValue(array $value): array
    {
        $result = [];
        unset($value['__empty']);

        foreach ($value as $row) {
            if (!is_array($row) || !array_key_exists(HreflangsConfigReader::STORE, $row)) {
                continue;
            }

            $result[$row[HreflangsConfigReader::STORE]] = $row;
        }

        return $result;
    }
}
