<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\SeoMarkup\Block\Head\SocialMarkup\Page;

class Home extends \MageWorx\SeoMarkup\Block\Head\SocialMarkup\Page
{
    /**
     * @return string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getPreparedUrl(): string
    {
        if (parse_url($this->_urlBuilder->getCurrentUrl(), PHP_URL_PATH) === '/graphql' && $this->getEntity()) {
            return $this->_storeManager->getStore()->getBaseUrl();
        }

        return parent::getPreparedUrl();
    }

    /**
     *
     * {@inheritDoc}
     */
    protected function isOgEnabled()
    {
        return $this->helperWebsite->isOgEnabled();
    }

    /**
     *
     * {@inheritDoc}
     */
    protected function isTwEnabled()
    {
        return $this->helperWebsite->isTwEnabled() && $this->helperWebsite->getTwUsername();
    }

    /**
     *
     * {@inheritDoc}
     */
    protected function getTwImageUrl()
    {
        return '';
    }

    /**
     *
     * {@inheritDoc}
     */
    protected function getTwUsername()
    {
        return $this->helperWebsite->getTwUsername();
    }

    /**
     *
     * {@inheritDoc}
     */
    protected function getOgType()
    {
        return 'website';
    }

    /**
     *
     * {@inheritDoc}
     */
    protected function getTwType()
    {
        return 'summary_large_image';
    }
}
