<?php
/**
 * Copyright © 2017 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\SeoRedirects\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

/**
 * @codeCoverageIgnore
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * {@inheritdoc}
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        if (version_compare($context->getVersion(), '2.1.0', '<')) {
            $this->addCustomRedirectsTable($setup);
        }

        if (version_compare($context->getVersion(), '2.2.1', '<')) {
            $this->addImportFieldToCustomRedirectTable($setup);
            $this->modifyTypeForIsAutogeneratedColumn($setup);
        }

        if (version_compare($context->getVersion(), '2.2.2', '<')) {
            $this->addDateRangeFieldsToCustomRedirectsTable($setup);
        }

        $setup->endSetup();
    }

    /**
     *
     * @param SchemaSetupInterface $setup
     */
    private function addCustomRedirectsTable(SchemaSetupInterface $setup)
    {
        $installer = $setup;
        $installer->startSetup();

        /**
         * Create table 'mageworx_seoredirects_redirect_custom'
         */
        $tableBaseRedirect = $installer->getConnection()->newTable(
            $installer->getTable('mageworx_seoredirects_redirect_custom')
        )
                                       ->addColumn(
                                           'redirect_id',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                                           null,
                                           [
                                               'identity' => true,
                                               'unsigned' => true,
                                               'nullable' => false,
                                               'primary'  => true,
                                           ],
                                           'Redirect ID'
                                       )
                                       ->addColumn(
                                           'redirect_code',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                                           null,
                                           [
                                               'unsigned' => true,
                                               'nullable' => true,
                                           ],
                                           'Redirect Code'
                                       )
                                       ->addColumn(
                                           'request_entity_type',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                                           null,
                                           [
                                               'unsigned' => true,
                                               'nullable' => true,
                                           ],
                                           'Request From(Type)'
                                       )
                                       ->addColumn(
                                           'request_entity_identifier',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                                           255,
                                           [],
                                           'Request Entity Identifier'
                                       )
                                       ->addColumn(
                                           'target_entity_type',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                                           null,
                                           [
                                               'unsigned' => true,
                                               'nullable' => true,
                                           ],
                                           'Request To(Type)'
                                       )
                                       ->addColumn(
                                           'target_entity_identifier',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                                           255,
                                           [],
                                           'Target Entity Identifier'
                                       )
                                       ->addColumn(
                                           'store_id',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                                           null,
                                           [
                                               'unsigned' => true,
                                               'nullable' => false,
                                               'default'  => '0'
                                           ],
                                           'Store Id'
                                       )
                                       ->addColumn(
                                           'date_created',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                                           null,
                                           [
                                               'nullable' => false,
                                               'default'  => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT
                                           ],
                                           'Creation Time'
                                       )
                                       ->addColumn(
                                           'date_modified',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                                           null,
                                           [
                                               'nullable' => false,
                                               'default'  => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE
                                           ],
                                           'Update Time'
                                       )
                                       ->addColumn(
                                           'is_autogenerated',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                                           null,
                                           [
                                               'unsigned' => true,
                                               'nullable' => false,
                                               'default'  => 0,
                                           ],
                                           'Is Autogenerated'
                                       )
                                       ->addColumn(
                                           'status',
                                           \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                                           null,
                                           [
                                               'unsigned' => true,
                                               'nullable' => false,
                                               'default'  => 1,
                                           ],
                                           'Is Active'
                                       )
                                       ->addIndex(
                                           $installer->getIdxName(
                                               'mageworx_seoredirects_redirect_custom',
                                               [
                                                   'request_entity_type',
                                                   'request_entity_identifier',
                                                   'store_id',
                                                   'status'
                                               ],
                                               \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE
                                           ),
                                           ['request_entity_type', 'request_entity_identifier', 'store_id', 'status'],
                                           ['type' => \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE]
                                       )
                                       ->addForeignKey(
                                           $installer->getFkName(
                                               'mageworx_seoredirects_redirect_custom',
                                               'store_id',
                                               'store',
                                               'store_id'
                                           ),
                                           'store_id',
                                           $installer->getTable('store'),
                                           'store_id',
                                           \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
                                       );

        $installer->getConnection()->createTable($tableBaseRedirect);
        $installer->endSetup();
    }

    /**
     * @param SchemaSetupInterface $setup
     */
    private function addImportFieldToCustomRedirectTable(SchemaSetupInterface $setup)
    {
        $setup->getConnection()->addColumn(
            $setup->getTable('mageworx_seoredirects_redirect_custom'),
            'is_imported',
            [
                'type'     => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                'nullable' => false,
                'default'  => 0,
                'comment'  => 'Is Imported',
            ]
        );
    }

    /**
     * @param SchemaSetupInterface $setup
     */
    private function modifyTypeForIsAutogeneratedColumn(SchemaSetupInterface $setup)
    {
        $setup->getConnection()->modifyColumn(
            $setup->getTable('mageworx_seoredirects_redirect_custom'),
            'is_autogenerated',
            [
                'type'     => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                'nullable' => false,
                'default'  => '0',
                'comment'  => 'Is Autogenerated',
            ]
        );
    }

    /**
     * @param SchemaSetupInterface $setup
     */
    private function addDateRangeFieldsToCustomRedirectsTable(SchemaSetupInterface $setup)
    {
        $setup->getConnection()->addColumn(
            $setup->getTable('mageworx_seoredirects_redirect_custom'),
            'start_at',
            [
                'type'     => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                'nullable' => true,
                'comment'  => 'Active From',
            ]
        );

        $setup->getConnection()->addColumn(
            $setup->getTable('mageworx_seoredirects_redirect_custom'),
            'finish_at',
            [
                'type'     => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                'nullable' => true,
                'comment'  => 'Active To',
            ]
        );
    }
}
