<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\SeoReports\Model\ResourceModel\CategoryReport;

class Collection extends \Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = 'entity_id';

    /**
     * @var bool
     */
    protected $joinUrls = false;

    /**
     * {@inheritdoc}
     */
    public function _construct()
    {
        $this->_init(
            'MageWorx\SeoReports\Model\CategoryReport',
            'MageWorx\SeoReports\Model\ResourceModel\CategoryReport'
        );
    }

    /**
     * @return $this
     */
    protected function joinUrls()
    {
        if (!$this->joinUrls) {
            $this->getSelect()
                 ->joinLeft(
                     ['url_rewrite' => $this->getTable('url_rewrite')],
                     sprintf(
                         'main_table.reference_id = url_rewrite.entity_id AND main_table.store_id = url_rewrite.store_id AND entity_type = \'%s\' AND url_rewrite.is_autogenerated = 1',
                         \Magento\CatalogUrlRewrite\Model\CategoryUrlRewriteGenerator::ENTITY_TYPE
                     ),
                     ['request_path']
                 );
            $this->joinUrls = true;
        }

        return $this;
    }


    /**
     * @param string $condition
     */
    public function addReferenceIdToFilter($condition)
    {
        $this->addFieldToFilter('reference_id', $condition);
    }


    /**
     * Get SQL for get record count
     *
     * Extra GROUP BY strip added.
     *
     * @return \Magento\Framework\DB\Select
     */
    public function getSelectCountSql()
    {
        $countSelect = parent::getSelectCountSql();
        $countSelect->reset(\Magento\Framework\DB\Select::GROUP);

        return $countSelect;
    }
}
