<?php
/**
 * Copyright © 2016 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\SeoXTemplates\Setup;

use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Catalog\Setup\CategorySetupFactory;

/**
 * Upgrade Data script
 * @codeCoverageIgnore
 */
class UpgradeData implements UpgradeDataInterface
{
    /**
     * Category setup factory
     *
     * @var CategorySetupFactory
     */
    private $categorySetupFactory;

    /**
     * @var \Magento\Eav\Model\ResourceModel\Entity\Attribute
     */
    protected $_eavAttribute;

    /**
     * UpgradeData constructor.
     * @param CategorySetupFactory $categorySetupFactory
     * @param \Magento\Eav\Model\ResourceModel\Entity\Attribute $eavAttribute
     */
    public function __construct(
        CategorySetupFactory $categorySetupFactory,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute $eavAttribute
    ) {
        $this->_eavAttribute = $eavAttribute;
        $this->categorySetupFactory = $categorySetupFactory;
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;

        $installer->startSetup();

        if (version_compare($context->getVersion(), '2.0.3', '<')) {

            $categorySetup = $this->categorySetupFactory->create(['setup' => $installer]);

            $categoryModifiedAttributes = [
                'meta_title',
                'meta_description',
                'meta_keywords',
                'description',
                'category_seo_name'
            ];
            $categoryEntity = \Magento\Catalog\Model\Category::ENTITY;
            $this->addNoteToAttributes($categorySetup, $categoryModifiedAttributes, $categoryEntity);

            $productModifiedAttributes = [
                'meta_title',
                'meta_description',
                'meta_keyword',
                'description',
                'short_description',
                'url_key',
                'product_seo_name'
            ];
            $productEntity = \Magento\Catalog\Model\Product::ENTITY;
            $this->addNoteToAttributes($categorySetup, $productModifiedAttributes, $productEntity);
        }

        $installer->endSetup();
    }

    /**
     * @param $categorySetup
     * @param $attributes
     * @param $entity
     */
    public function addNoteToAttributes($categorySetup, $attributes, $entity) {
        foreach ($attributes as $attribute) {
            $this->_eavAttribute->getIdByCode('customer', 'company_name');

            $categorySetup->updateAttribute(
                $entity,
                $attribute,
                'note',
                'Note: Switch to a store view level to see the "'. $attribute . '" attribute generated by MageWorx templates.'
            );
        }
    }
}
