<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Controller\Adminhtml\Shippingrules\Region;

use Magento\Framework\Exception\LocalizedException;
use MageWorx\ShippingRules\Controller\Adminhtml\Shippingrules\Region as RegionParentController;

/**
 * Class Delete
 */
class Delete extends RegionParentController
{
    /**
     * Delete region action
     *
     * @return void
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');
        if ($id) {
            try {
                /** @var \MageWorx\ShippingRules\Model\Region $model */
                $this->regionRepository->deleteById($id);
                $this->messageManager->addSuccessMessage(__('You deleted the region'));
                $this->_redirect('mageworx_shippingrules/*/');

                return;
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(
                    __('We can\'t delete the region right now. Please review the log and try again.')
                );
                $this->logger->critical($e);
                $this->_redirect('mageworx_shippingrules/*/edit', ['id' => $this->getRequest()->getParam('id')]);

                return;
            }
        }
        $this->messageManager->addErrorMessage(__('We can\'t find a region to delete.'));
        $this->_redirect('mageworx_shippingrules/*/');
    }
}
