<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Block\Adminhtml\Askforprice;

/**
 * AskForPrice Edit form
 */
class Edit extends \Magento\Backend\Block\Widget\Form\Container
{
	/**
	 * Core Registry
	 *
	 * @var $_coreRegistry = null
	 */
    protected $_coreRegistry = null;

	/**
	 * @param \Magento\Backend\Block\Template\Context 
	 * @param \Magento\Framework\Registry 
	 * @param array $data
	 */
    public function __construct(
        \Magento\Backend\Block\Widget\Context $context,
        \Magento\Framework\Registry $registry,
        array $data = []
    ) {
        $this->_coreRegistry = $registry;
        parent::__construct($context, $data);
    }

    protected function _construct()
    {
        $this->_objectId = 'entity_id';
        $this->_blockGroup = 'Mageants_AskForPrice';
        $this->_controller = 'adminhtml_Askforprice';
		parent::_construct();
		
		$this->buttonList->remove('save');
        $this->buttonList->remove('reset');
        if ($this->_isAllowedAction('Mageants_AskForPrice::askforprice_delete')) {
            $this->buttonList->update('delete', 'label', __('Delete Record'));
        } else {
            $this->buttonList->remove('delete');
        }
    }
    
	/**
	 * Get header text for admin askforprice form
	 *
	 * @return String
	 */ 
    public function getHeaderText()
    {
        if ($this->_coreRegistry->registry('askforprice_data')->getId()) {
            return __("Edit Record '%1'", $this->escapeHtml($this->_coreRegistry->registry('askforprice_data')->getTitle()));
        } else {
            return __('New Record');
        }
    }
	
	/**
	 * Check permission for passed action
	 *
	 * @param string $resourceId
	 * @return bool
	 */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }

	/**
	 * save and continue for askforprice
	 *
	 * @return String
	 */ 
    protected function _getSaveAndContinueUrl()
    {
        return $this->getUrl('askforprice/*/save', ['_current' => true, 'back' => 'Edit', 'active_tab' => '']);
    }
}
