<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Block\Adminhtml\Askforprice\Edit;
/**
 * AskForPrice Form
 */
class Form extends \Magento\Backend\Block\Widget\Form\Generic
{
	/**
	 * @param \Magento\Backend\Block\Template\Context 
	 * @param \Magento\Framework\Registry 
	 * @param \Magento\Framework\Data\FormFactory
	 * @param \Magento\Store\Model\System\Store
	 * @param array $data
	 */
	public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        array $data = []
    ) {
        parent::__construct($context, $registry, $formFactory, $data);
    }

    protected function _construct()
    {
        parent::_construct();
        $this->setId('askforprice_form');
        $this->setTitle(__('Askforprice Information'));
    }
	
	/**
	 * Prepare form
	 *
	 * @return $this
	 */ 
    protected function _prepareForm()
    {
        $model = $this->_coreRegistry->registry('askforprice_data');
		$form = $this->_formFactory->create(
            ['data' => ['id' => 'View_form', 'action' => $this->getData('action'), 'method' => 'post', 'enctype' => 'multipart/form-data']]
        );

        $fieldset = $form->addFieldset(
            'base_fieldset',
            ['legend' => __('Customer Information'), 'class' => 'fieldset-wide']
        );

        if ($model->getId()) {
            $fieldset->addField('entity_id', 'hidden', ['name' => 'entity_id']);
        }

        $fieldset->addField(
            'name',
            'text',
            ['name' => 'name', 'label' => __('Customer Name'), 'title' => __('Customer Name'), 'required' => false,'disabled' => true]
        );

        $fieldset->addField(
            'pname',
            'text',
            ['name' => 'pname', 'label' => __('Product Name'), 'title' => __('Product Name'), 'required' => false,'disabled' => true]
        ); 

		$fieldset->addField(
            'sku',
            'text',
            ['name' => 'sku', 'label' => __('Product Sku'), 'title' => __('Product Sku'), 'required' => false,'disabled' => true]
        );

		$fieldset->addField(
            'email',
            'text',
            ['name' => 'email', 'label' => __('Email'), 'title' => __('Email'), 'required' => false,'disabled' => true]
        );

		$fieldset->addField(
            'request',
            'textarea',
            ['name' => 'request', 'label' => __('Request'), 'title' => __('Request'), 'required' => false,'disabled' => true]
        );

		$fieldset->addField(
            'telephone',
            'text',
            ['name' => 'telephone', 'label' => __('Telephone'), 'title' => __('Telephone'), 'required' => false,'disabled' => true]
        );

        $form->setValues($model->getData());
        $form->setUseContainer(true);
        $this->setForm($form);
		return parent::_prepareForm();
    }
}