<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Block;

use Magento\Framework\View\Element\Template\Context;
use Magento\Catalog\Model\Product;
use Magento\Framework\Pricing\Price\PriceInterface;
use Magento\Framework\Pricing\Render\RendererPool;

/**
 * Product price block
 */
class FinalPriceBoxBundle extends \Magento\Bundle\Pricing\Render\FinalPriceBox 
{  
	/**
	 * current customer session
	 *
	 * @var \Magento\Customer\Model\Session
	 */
	protected $customerSession;
	/**
     * @var \Magento\Framework\Registry
     */
    protected $registry;
    /**
     * @var \Mageants\AskForPrice\Helper\Data
     */
    protected $helperData;
	
	/**
	 * @param \Magento\Backend\Block\Template\Context 
	 * @param \Magento\Catalog\Model\Product
	 * @param \Magento\Framework\Pricing\Price\PriceInterface
	 * @param \Magento\Framework\Pricing\Render\RendererPool
	 * @param \Magento\Customer\Model\Session
	 * @param array $data
	 */
    public function __construct(
		Context $context,
        Product $saleableItem,
        PriceInterface $price,
        RendererPool $rendererPool,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\Registry $registry,
        \Mageants\AskForPrice\Helper\Data $helperData,
		array $data = []
    ) {
        $this->customerSession = $customerSession;
        $this->registry=$registry;
        $this->helperData = $helperData;
        parent::__construct($context, $saleableItem, $price, $rendererPool);
    }
    public function showRangePrice()
    {
        $module=$this->_scopeConfig->getValue('rock_askforprice/module/askforprice', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		/** 
		 * Get Product Name,Id,Sku
		 */
		$pname=$this->getSaleableItem()->getName();
		$pid=$this->getSaleableItem()->getId();
		$sku=$this->getSaleableItem()->getSku();
		if($module==1)		
		{
			/**
			 * Set AskForPrice Label
			 */
			
			$product = $this->getSaleableItem();
			$priority = $this->helperData->getPriority($product);
			$customerGroups=$this->helperData->getCustomerGroups($product,$priority);
			$label=$this->helperData->getLabel($product,$priority);
			$category_ids = $this->helperData->getCategoryIds($priority);
			$customergroupId=$this->customerSession->getCustomerGroupId();
			$product_cat_ids = $product->getCategoryIds();

			$captcha_key=$this->_scopeConfig->getValue('rock_askforprice/captcha/captcha_option', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
			$email="";
			$name="";
			$customer_id = $this->customerSession->getCustomerId();  // get Customer Id
			/**
			 * Set Name and Email if customer is Login
			 */
			if($customer_id){
				$email=$this->customerSession->getCustomerData()->getEmail();
				$fname=$this->customerSession->getCustomerData()->getFirstname();
				$lname=$this->customerSession->getCustomerData()->getLastname();
				$name=$fname.' '.$lname;
			}
			$adminemail=$this->_scopeConfig->getValue('trans_email/ident_support/email', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
			$adminname=$this->_scopeConfig->getValue('trans_email/ident_support/name', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

			if($this->getSaleableItem()->getAskforpriceText() != NULL){
				/** 
				   * Attribute set then set AskForPrice
				   */
					if($priority == 'call_for_price')
					{
						if (in_array($customergroupId,$customerGroups))
						{
							$email="";
							$name="";
							$customer_id = $this->customerSession->getCustomerId();  // get Customer Id
							/**
							 * Set Name and Email if customer is Login
							 */
							if($customer_id){
								$email=$this->customerSession->getCustomerData()->getEmail();
								$fname=$this->customerSession->getCustomerData()->getFirstname();
								$lname=$this->customerSession->getCustomerData()->getLastname();
								$name=$fname.' '.$lname;
							}
							$adminemail=$this->_scopeConfig->getValue('trans_email/ident_support/email', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
							$adminname=$this->_scopeConfig->getValue('trans_email/ident_support/name', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);          
							
							$html='
								<div id="rock_popup" name="'.$pid.'" class="price-box" ><button class="askforpricebutton" data-pid="'.$pid.'" data-pname="'.$pname.'" data-sku="'.$sku.'"
								data-adminemail="'.$adminemail.'" data-adminname="'.$adminname.'" data-email="'.$email.'"
								data-name="'.$name.'" 	data-capchakey="'.$captcha_key.'" name="'.$pid.'">'.$label.'</button></div>
								
							<script type="text/javascript">
								require(["jquery","askforprice/popup"], function($) {
								jQuery(document).ready(function($) {
								$("#rock_popup button").click(function(){
									var msglist = $(this);
									var pid = msglist.data("pid");
									var pname = msglist.data("pname");
									var sku = msglist.data("sku");
									var adminemail = msglist.data("adminemail");
									var adminname = msglist.data("adminname");
									var capchakey = msglist.data("capchakey");
									var email = msglist.data("email");
									var name = msglist.data("name");
									
									$("#pid").val(pid);
									$("#pname").val(pname);
									$("#email").val(email);
									$("#name").val(name);
									$(".setpname").text(pname);
									$("#sku").val(sku);
									$("#adminemail").val(adminemail);
									$("#adminname").val(adminname);
									$("#captcha_key").val(capchakey);
									$("#rocktech-capcha").attr("data-sitekey",capchakey );
									
									var left = 150 ;
									var top =  30;
									var pid=$(this).attr("name")
									
									$("#Mageants-askforprice-popup").bPopup({
									  position: [left,top],
									  modalClose:true
								  });
								});
								});
								});
							</script>
							';
						}
						else
						{
							/** 
							 * Attribute not set then return with price
							 */
							$bundlePrice = $this->getPriceType(FinalPrice::PRICE_CODE);
					        $showRange = $bundlePrice->getMinimalPrice() != $bundlePrice->getMaximalPrice();

					        if (!$showRange) {
					            //Check the custom options, if any
					            /** @var \Magento\Catalog\Pricing\Price\CustomOptionPrice $customOptionPrice */
					            $customOptionPrice = $this->getPriceType(CustomOptionPrice::PRICE_CODE);
					            $showRange =
					                $customOptionPrice->getCustomOptionRange(true) != $customOptionPrice->getCustomOptionRange(false);
					        }

					        return $showRange;
						}				
					}
					else
					{						
						if (in_array($customergroupId,$customerGroups))
						{
							$html= '<div id="rock_popup" class="price-box" data-role="priceBox" ><span>'.$label.'</span></div>';	
						}
						else
						{
							$bundlePrice = $this->getPriceType(FinalPrice::PRICE_CODE);
					        $showRange = $bundlePrice->getMinimalPrice() != $bundlePrice->getMaximalPrice();

					        if (!$showRange) {
					            //Check the custom options, if any
					            /** @var \Magento\Catalog\Pricing\Price\CustomOptionPrice $customOptionPrice */
					            $customOptionPrice = $this->getPriceType(CustomOptionPrice::PRICE_CODE);
					            $showRange =
					                $customOptionPrice->getCustomOptionRange(true) != $customOptionPrice->getCustomOptionRange(false);
					        }

					        return $showRange;
						}
					  /**
					   * Popup is Disable for Frontend
					   */
						
					}
				return $html;
			}
			/** 
			 * Check AskforpriceText attribute is set or not for product
			 */
			
			elseif($category_ids!=NULL && !empty(array_intersect($product_cat_ids, $category_ids)))
			{
				$confPriority=$this->helperData->GetConfigValue('rock_askforprice/price_priority/priority');
				if($confPriority == 'call_for_price')
				{					
					if (in_array($customergroupId,$customerGroups))
					{
						$email="";
						$name="";
						$customer_id = $this->customerSession->getCustomerId();  // get Customer Id
						/**
						 * Set Name and Email if customer is Login
						 */
						if($customer_id){
							$email=$this->customerSession->getCustomerData()->getEmail();
							$fname=$this->customerSession->getCustomerData()->getFirstname();
							$lname=$this->customerSession->getCustomerData()->getLastname();
							$name=$fname.' '.$lname;
						}
						$adminemail=$this->_scopeConfig->getValue('trans_email/ident_support/email', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
						$adminname=$this->_scopeConfig->getValue('trans_email/ident_support/name', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);          
						
						$html='
							<div id="rock_popup" name="'.$pid.'" class="price-box" ><button class="askforpricebutton" data-pid="'.$pid.'" data-pname="'.$pname.'" data-sku="'.$sku.'"
							data-adminemail="'.$adminemail.'" data-adminname="'.$adminname.'" data-email="'.$email.'"
							data-name="'.$name.'" 	data-capchakey="'.$captcha_key.'" name="'.$pid.'">'.$label.'</button></div>
							
						<script type="text/javascript">
							require(["jquery","askforprice/popup"], function($) {
							jQuery(document).ready(function($) {
							$("#rock_popup button").click(function(){
								var msglist = $(this);
								var pid = msglist.data("pid");
								var pname = msglist.data("pname");
								var sku = msglist.data("sku");
								var adminemail = msglist.data("adminemail");
								var adminname = msglist.data("adminname");
								var capchakey = msglist.data("capchakey");
								var email = msglist.data("email");
								var name = msglist.data("name");
								
								$("#pid").val(pid);
								$("#pname").val(pname);
								$("#email").val(email);
								$("#name").val(name);
								$(".setpname").text(pname);
								$("#sku").val(sku);
								$("#adminemail").val(adminemail);
								$("#adminname").val(adminname);
								$("#captcha_key").val(capchakey);
								$("#rocktech-capcha").attr("data-sitekey",capchakey );
								
								var left = 150 ;
								var top =  30;
								var pid=$(this).attr("name")
								
								$("#Mageants-askforprice-popup").bPopup({
								  position: [left,top],
								  modalClose:true
							  });
							});
							});
							});
						</script>
						';
					}
					else
					{
						return '<div class="price-box ' . $this->getData('css_classes') . '" ' .
						'data-role="priceBox" ' .
						'data-product-id="' . $this->getSaleableItem()->getId() . '"' .
						'>' . $html . '</div>';
					}				
				}
				else
				{					
					if (in_array($customergroupId,$customerGroups))
					{
						$html= '<div id="rock_popup" class="price-box" data-role="priceBox" ><span>'.$label.'</span></div>';	
					}
					else
					{
						$bundlePrice = $this->getPriceType(FinalPrice::PRICE_CODE);
				        $showRange = $bundlePrice->getMinimalPrice() != $bundlePrice->getMaximalPrice();

				        if (!$showRange) {
				            //Check the custom options, if any
				            /** @var \Magento\Catalog\Pricing\Price\CustomOptionPrice $customOptionPrice */
				            $customOptionPrice = $this->getPriceType(CustomOptionPrice::PRICE_CODE);
				            $showRange =
				                $customOptionPrice->getCustomOptionRange(true) != $customOptionPrice->getCustomOptionRange(false);
				        }

				        return $showRange;
					}
				  /**
				   * Popup is Disable for Frontend
				   */
					
				}
			return $html;
			}
			else
			{
				/** 
				 * Attribute not set then return with price
				 */
				$bundlePrice = $this->getPriceType(FinalPrice::PRICE_CODE);
		        $showRange = $bundlePrice->getMinimalPrice() != $bundlePrice->getMaximalPrice();

		        if (!$showRange) {
		            //Check the custom options, if any
		            /** @var \Magento\Catalog\Pricing\Price\CustomOptionPrice $customOptionPrice */
		            $customOptionPrice = $this->getPriceType(CustomOptionPrice::PRICE_CODE);
		            $showRange =
		                $customOptionPrice->getCustomOptionRange(true) != $customOptionPrice->getCustomOptionRange(false);
		        }

		        return $showRange;
			}
		}
		else
		{
			/** 
			 * Attribute not set then return with price
			 */
			$bundlePrice = $this->getPriceType(FinalPrice::PRICE_CODE);
	        $showRange = $bundlePrice->getMinimalPrice() != $bundlePrice->getMaximalPrice();

	        if (!$showRange) {
	            //Check the custom options, if any
	            /** @var \Magento\Catalog\Pricing\Price\CustomOptionPrice $customOptionPrice */
	            $customOptionPrice = $this->getPriceType(CustomOptionPrice::PRICE_CODE);
	            $showRange =
	                $customOptionPrice->getCustomOptionRange(true) != $customOptionPrice->getCustomOptionRange(false);
	        }

	        return $showRange;
		}
    }
	
	/**
	 * Prepare Layout
	 *
	 * @return layout
	 */ 
    protected function _prepareLayout()
    {
		return parent::_prepareLayout();
    }
}
