<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Controller\Adminhtml\Askforprice;
use Magento\Backend\App\Action;
use Magento\TestFramework\ErrorLog\Logger;
use Mageants\AskForPrice\Model\Askforprice;
/**
 * AskForPrice Delete Action
 */
class Delete extends \Magento\Backend\App\Action
{
    /**
     * @var AskForPrice $_askforprice
     */
    protected $_askforprice;

    /**
     * @param Context $context
     * @param $attach_model
     */
    public function __construct(Action\Context $context,Askforprice $_askforprice)
    {
        $this->_askforprice = $_askforprice;
        parent::__construct($context);
    }

	/**
	 * {@inheritdoc}
	 */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Mageants_AskForPrice::askforprice_delete');
    }
	
	/**
	 * perform delete Action
	 *
	 * @return $resultRedirect
	 */ 
    public function execute()
    {
        /**
         * Delete single record from admin Grid
         */            
        $id = $this->getRequest()->getParam('entity_id');
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                $model = $this->_askforprice;
                $model->load($id);
                $model->delete();
                $this->messageManager->addSuccess(__('The Record has been deleted.'));
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['entity_id' => $id]);
            }
        }
        $this->messageManager->addError(__('We can\'t find a record to delete.'));
        return $resultRedirect->setPath('*/*/');
    }
}