<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Controller\Adminhtml\Askforprice;
use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;

/**
 * AskForPrice Index Action
 */
class Index extends \Magento\Backend\App\Action
{
	/**
	 * Result page factory
	 *
	 * @var \Magento\Framework\View\Result\PageFactory
	 */
    protected $resultPageFactory;

	/**
	 * @param \Magento\Backend\Block\Template\Context 
	 * @param \Magento\Framework\View\Result\PageFactory
	 */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
    }

	/**
	 * {@inheritdoc}
	 */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Mageants_AskForPrice::askforprice');
    }

	/**
	 * perform Index Action
	 *
	 * @return $resultPage
	 */ 
    public function execute()
    {
        /**
         * render The admin grid page
         */            
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Mageants_AskForPrice::askforprice_content');
        $resultPage->addBreadcrumb(__('Record'), __('Record'));
        $resultPage->addBreadcrumb(__('Manage Records'), __('Manage Records'));
        $resultPage->getConfig()->getTitle()->prepend(__('Records'));

        return $resultPage;
    }
}
