<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Controller\Adminhtml\Askforprice;
use Magento\Backend\App\Action;
use Mageants\AskForPrice\Model\Askforprice;

/**
 * AskForPrice Edit Action
 */
class Edit extends \Magento\Backend\App\Action
{
    /**
     * @var AskForPrice $_askforprice
     */
    protected $_askforprice;

    /**
     * @var Session $_modelSession
     */
    protected $_modelSession;


	/**
	 * Core registry
	 *
	 * @var coreRegistry=null
	 */
    protected $_coreRegistry = null;
	
	/**
	 * Result page factory
	 *
	 * @var \Magento\Framework\View\Result\PageFactory
	 */
	protected $resultPageFactory;
	
	/**
	 * @param \Magento\Backend\Block\Template\Context 
	 * @param \Magento\Framework\View\Result\PageFactory
	 * @param \Magento\Framework\Registry
	 */
    public function __construct(
        Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Registry $registry,
        Askforprice $_askforprice,
        \Magento\Backend\Model\Session $ModelSession
    ) {
        $this->_modelSession=$ModelSession;
        $this->_askforprice = $_askforprice;
        $this->resultPageFactory = $resultPageFactory;
        $this->_coreRegistry = $registry;
        parent::__construct($context);
    }

	/**
	 * {@inheritdoc}
	 */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Mageants_AskForPrice::save');
    }

	/**
	 * Intialize Action
	 *
	 * @return $resultPage
	 */ 
    protected function _initAction()
    {
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Mageants_AskForPrice::askforprice_content')
            ->addBreadcrumb(__('AskForPrice'), __('AskForPrice'))
            ->addBreadcrumb(__('Manage Records'), __('Manage Records'));
        return $resultPage;
    }

	/**
	 * perform Edit Action
	 *
	 * @return $resultPage
	 */ 
    public function execute()
    {
        // 1. Get ID and create model
        $id = $this->getRequest()->getParam('entity_id');
        $model = $this->_askforprice;

        // 2. Initial checking
        if ($id) {
            $model->load($id);
            if (!$model->getId()) {
                $this->messageManager->addError(__('This record no longer exists.'));
                /** \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
                $resultRedirect = $this->resultRedirectFactory->create();

                return $resultRedirect->setPath('*/*/');
            }
        }

        // 3. Set entered data if was error when we do save
        $data = $this->_modelSession->getFormData(true);
        if (!empty($data)) {
            $model->setData($data);
        }

        // 4. Register model to use later in blocks
        $this->_coreRegistry->register('askforprice_data', $model);

        // 5. Build edit form
        $resultPage = $this->_initAction();
        $resultPage->addBreadcrumb(
            $id ? __('Edit Record') : __('New Record'),
            $id ? __('Edit Record') : __('New Record')
        );

        $resultPage->getConfig()->getTitle()->prepend(__('Records'));
        $resultPage->getConfig()->getTitle()
            ->prepend($model->getId() ? $model->getTitle() : __('New Record'));
          
        return $resultPage;
    }
}
