<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Controller\Index;
use Magento\Framework\App\Action\Action;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Element\Template as template;
use Magento\Catalog\Api\ProductRepositoryInterface;
//fuxz
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * AskForPrice save Action
 */
class Save extends Action 
{
	/**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

	/**
     * @var \Magento\Framework\Mail\Template\TransportBuilder
     */
    protected $_transportBuilder;
	
	/**
     * @var \Magento\Framework\Translate\Inline\StateInterface
     */
    protected $inlineTranslation;

	/**
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\Mail\Template\TransportBuilder $_transportBuilder
     * @param \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation
     */
    public function __construct(
            \Magento\Framework\App\Action\Context $context,
            \Magento\Store\Model\StoreManagerInterface $storeManager,
            \Magento\Framework\Mail\Template\TransportBuilder $_transportBuilder,
            \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
            \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    ) {
        parent::__construct(
            $context
        );
        $this->storeManager = $storeManager;
        $this->_transportBuilder=$_transportBuilder;
        $this->inlineTranslation=$inlineTranslation;
        $this->_scopeConfig=$scopeConfig;
    }
    
	/**
	 * perform save Action
	 *
	 * @return $resultRedirect
	 */ 
    public function execute()
    {
        /**
         * Save Customer request 
         */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $data=$this->getRequest()->getPostValue();
        $enalebCaptcha = $this->_scopeConfig->getValue('rock_askforprice/captcha/captcha_option', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        if($enalebCaptcha==1)
        {
        	if(isset($data["g-recaptcha-response"]))
        	{	
        		$secret = $this->_scopeConfig->getValue('rock_askforprice/captcha/captcha_secret_key', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		        //get verify response data
		        $verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secret.'&response='.$data['g-recaptcha-response']);
		        $responseData = json_decode($verifyResponse);
		        if(!$responseData->success)
		        {
		        	$this->messageManager->addError('Request not Accepted. Please Verify Google Captcha Again.');
					$resultRedirect->setUrl($this->_redirect->getRefererUrl());
					return $resultRedirect; 	
		        }
        	}else{
        		$this->messageManager->addError('Request not Accepted. Please Verify Google Captcha Again.');
				$resultRedirect->setUrl($this->_redirect->getRefererUrl());
				return $resultRedirect; 	
        	}
        }
   		$model = $this->_objectManager->create('Mageants\AskForPrice\Model\Askforprice');
        $model->setData($data);
        if($model->save())
        {        
			try 
			{		
				/**
				 * Send Mail to User
				 */
				$adminEmail=$data['adminemail'];
				$adminName=$data['adminname'];
				$name=$adminName;
				$to=$data['email'];

				//email administradores fuxz
				$nombre_administrador = $this->_scopeConfig->getValue('trans_email/ident_support/name',ScopeInterface::SCOPE_STORE);
				$correo_administrador = $this->_scopeConfig->getValue('trans_email/ident_support/email',ScopeInterface::SCOPE_STORE);

				$templateVars = array(
									'name'	  => $data['name'],
									'message' => 'Su solicitud de stock ha sido enviada, lo contactaremos lo más pronto posible.',
								);
				$from = array('email' => $correo_administrador, 'name' => $nombre_administrador);
				
				$templateOptions = array('area' => \Magento\Framework\App\Area::AREA_FRONTEND, 'store' => $this->storeManager->getStore()->getId());			 

				$transport = $this->_transportBuilder
						->setTemplateIdentifier('askforprice_email')
						->setTemplateOptions($templateOptions)
						->setTemplateVars($templateVars)
						->setFrom($from)
						->addTo($data['email'],$data['name'])
						->setReplyTo($correo_administrador)
						->getTransport();

				$transport->sendMessage(); 
				
				/**
				 * Send Mail to Admin 
			 	 */
				$templateVars = array(
									'pname' => $data['pname'],
									'sku' => $data['sku'],
									'cname' => $data['name'],
									'cemail' => $data['email'],
									'ctelephone'  => $data['telephone'],
									'crequest'=>$data['request']
								);

				$from = array('email' => $correo_administrador, 'name' => $nombre_administrador);
				$templateOptions = array('area' => \Magento\Framework\App\Area::AREA_FRONTEND, 'store' => $this->storeManager->getStore()->getId());

				$transport = $this->_transportBuilder
						->setTemplateIdentifier('rock_askforprice_admin_notification_admin_email_template')
						->setTemplateOptions($templateOptions)
						->setTemplateVars($templateVars)
						->setFrom($from)
						->addTo($correo_administrador,$nombre_administrador)
						->setReplyTo($data['email'])
						->getTransport();

				$transport->sendMessage(); 
				 
				$this->messageManager->addSuccess( __('Su solicitud de stock ha sido enviada, lo contactaremos lo más pronto posible.') );   
			}
			catch (\Exception $e) {				
				$this->messageManager->addSuccess('Tuvimos problemas al enviar la solicitud de stock, por favor, contáctenos directamente al correo: '.$correo_administrador);
				$resultRedirect->setUrl($this->_redirect->getRefererUrl());
				return $resultRedirect;
			}
		}
		else
		{ 
			$this->messageManager->addError('Error al enviar la solicitud de stock, por favor, vuelve a intenarlo más tarde o contáctenos directamente al correo: '.$correo_administrador); 
		} 
		$resultRedirect->setUrl($this->_redirect->getRefererUrl());
		return $resultRedirect;
	} 
}
