<?php
/**
 * @category  Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Helper;

/**
 * AskForPrice Helper Data class
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
	/**
     * @var \Magento\Customer\Model\Session
     */
	protected $customerSession;
	/**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;
    /**
     * @var \Magento\Catalog\Model\Product 
     */
    protected $productFactory;

	/**
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Catalog\Model\Product $productFactory
     */	
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Catalog\Model\Product $productFactory
    ) {
        parent::__construct($context);
        $this->scopeConfig = $context->getScopeConfig();
		$this->customerSession = $customerSession;
		$this->productFactory = $productFactory;
    }
	
	/**
	 * Check configuration for AskForPrice
	 *
	 * @param string $config_path
	 * @return $String
	 */
	public function GetConfigValue($config_path)
    {
        return $this->scopeConfig->getValue(
            $config_path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
	/**
	 * Check Customer Id
	 *
	 * @return $String
	 */
	public function getCustomerId()
	{
		return $this->customerSession->getCustomerGroupId();
	}
	public function getCustomerSession()
	{
		return $this->customerSession;
	}
	/**
	 * get Product
	 *
	 * @return $String
	 */
	public function getProduct($pid){
		return $this->productFactory->load($pid);
	}
	/**
	 * Get Priority
	 *
	 * @return $String
	 */
	public function getPriority($product)
	{
		$priority = NULL;
		//$product = $this->getProduct($pid);
		$productPriority = $product->getAskforpriceText();
		$confPriority=$this->GetConfigValue('rock_askforprice/price_priority/priority');
		if($productPriority != NULL){
			$priority = $productPriority;
		}
		elseif($confPriority != NULL){
			$priority = $confPriority;
		}
		else{
			$priority = 'call_for_price';
		}
		return $priority;
	}
	/**
	 * Get Customer Groups
	 *
	 * @return $Array
	 */
	public function getCustomerGroups($product,$priority)
	{
		//$product = $this->getProduct($pid);
		$customerGroups = NULL;
		$customerGroup = $product->getAskforpriceCustomerGroup();
		if($customerGroup == NULL){
			if($priority == 'call_for_price'){
				$customerGroup=$this->GetConfigValue('rock_askforprice/callforprice_global/customers');
			}
			elseif($priority == 'hide_price'){
				$customerGroup=$this->GetConfigValue('rock_askforprice/hideprice_global/customers');
			}
		}
		if($customerGroup !=NULL){
			$customerGroups = explode(',', $customerGroup);
		}
		return $customerGroups;
	}
	/**
	 * Get Label
	 *
	 * @return $String
	 */
	public function getLabel($product,$priority)
	{
		$label = NULL;
		//$product = $this->getProduct($pid);
		$productLabel=$product->getAskforpriceTextbox();
		if($productLabel != NULL){
			$label = $productLabel;
		}
		else{
			if($priority == 'call_for_price'){
				$label = $this->GetConfigValue('rock_askforprice/callforprice_global/text');					
			}
			elseif($priority == 'hide_price'){
				$label = $this->GetConfigValue('rock_askforprice/hideprice_global/text');
			}
		}
		return $label;
	}
	/**
	 * Get Categories
	 *
	 * @return $Array
	 */
	public function getCategoryIds($priority)
	{
		$category_id = NULL;
		if($priority == 'call_for_price'){
			$category_id=$this->GetConfigValue('rock_askforprice/callforprice_global/categories');
		}
		elseif($priority == 'hide_price'){
			$category_id=$this->GetConfigValue('rock_askforprice/hideprice_global/categories');
		}
		$category_ids=NULL;
        if($category_id != NULL){
        	$category_ids = explode(',', $category_id);
        }
		return $category_ids;
	}
	public function getNotApplyIds($priority)
	{
		$product_id = NULL;
		if($priority == 'call_for_price'){
			$product_id=$this->GetConfigValue('rock_askforprice/callforprice_global/not_apply');
		}
		elseif($priority == 'hide_price'){
			$product_id=$this->GetConfigValue('rock_askforprice/hideprice_global/not_apply');
		}
		$product_ids=array('0' => 0);
        if($product_id != NULL){
        	$product_ids = explode(',', $product_id);
        }
		return $product_ids;
	}
	
}
