<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Model\ResourceModel;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Context;
use Magento\Framework\Stdlib\DateTime\DateTime;
use Magento\Framework\Model\AbstractModel;

/*
 * Askforprice resourceModel
 */
class Askforprice extends AbstractDb
{
	/**
     * @var $_date
     */
    protected $_date;

	/**
     * @param Context $context
     * @param DateTime $date
     */	
    public function __construct(
        Context $context,
        DateTime $date,
        $resourcePrefix = null
    ) {
        parent::__construct($context, $resourcePrefix);
        $this->_date = $date;
    }

    protected function _construct()
    {
        $this->_init('Mageants_askforprice_askforprice', 'entity_id');
    }

	/**
	 * Before save Model perform Action
	 *
	 * @param AbstractModel $object
	 * @return parent::_beforeSave
	 */
    protected function _beforeSave(AbstractModel $object)
    {
        if ($object->isObjectNew() && !$object->hasCreationTime()) {
            $object->setCreationTime($this->_date->gmtDate());
        }
        $object->setUpdateTime($this->_date->gmtDate());
        return parent::_beforeSave($object);
    }

	/**
	 * Get Load select for model
	 *
	 * @param String $field
	 * @param String $value
	 * @param String $object
	 * @return parent::_getLoadSelect
	 */
    protected function _getLoadSelect($field, $value, $object)
    {
        $select = parent::_getLoadSelect($field, $value, $object);
        if ($object->getStoreId()) {
            $select->where(
                'is_active = ?',
                1
            )->limit(
                1
            );
        }
        return $select;
    }
}