<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Observer;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Registry;

/*
 * RemoveBlock Observer before render block
 */
class RemoveBlock implements ObserverInterface
{   
    /**
     * current customer session
     *
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;
    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;
    /**
     * @var \Mageants\AskForPrice\Helper\Data
     */
    protected $helperData;

	/**
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Framework\Registry $registry
     * @param \Mageants\AskForPrice\Helper\Data $helperData
     */	
    public function __construct(
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\Registry $registry,
        \Mageants\AskForPrice\Helper\Data $helperData
    ) {
        $this->customerSession = $customerSession;
        $this->registry=$registry;
        $this->helperData = $helperData;
    }

    public function execute(Observer $observer)
    { 
        $layout = $observer->getLayout();
        $removelist = $this->helperData->GetConfigValue('rock_askforprice/module/askforprice');    
        $product = $this->registry->registry('product');
        if($product != NULL){
            $priority = $this->helperData->getPriority($product);
            $customerGroups=$this->helperData->getCustomerGroups($product,$priority);
            $label=$this->helperData->getLabel($product,$priority);
            $category_ids = $this->helperData->getCategoryIds($priority);
            $customergroupId=$this->customerSession->getCustomerGroupId();
            $product_cat_ids = $product->getCategoryIds();
            $notApplyIds=$this->helperData->getNotApplyIds($priority);

            $block = $layout->getBlock('product.info.addtocart');
            if ($block) {
                $addtocart = $this->helperData->GetConfigValue('rock_askforprice/general/enabled');
                if ($removelist == 1 ) {
                     if($product->getAskforpriceText() != NULL){
                        if(in_array($customergroupId,$customerGroups)) {                            
                            if($addtocart != 1){ 
                                $layout->unsetElement('product.info.addtocart');
                            }
                        }
                    }
                    elseif($category_ids!=NULL && !empty(array_intersect($product_cat_ids, $category_ids))){
                        if(!in_array($product->getId(), $notApplyIds)){
                            if (in_array($customergroupId,$customerGroups)){
                                if($addtocart != 1){
                                    $layout->unsetElement('product.info.addtocart');
                                }
                            } 
                        }
                        
                    }
                }
            }

            $block = $layout->getBlock('customize.button');
            if ($block) {
                $addtocart = $this->helperData->GetConfigValue('rock_askforprice/general/enabled');
                if ($removelist == 1 ) {
                     if($product->getAskforpriceText() != NULL){
                        if(in_array($customergroupId,$customerGroups)) {                            
                            if($addtocart != 1){ 
                                $layout->unsetElement('customize.button');
                            }
                        }
                    }
                    elseif($category_ids!=NULL && !empty(array_intersect($product_cat_ids, $category_ids))){
                        if(!in_array($product->getId(), $notApplyIds)){
                            if (in_array($customergroupId,$customerGroups)){
                                if($addtocart != 1){
                                    $layout->unsetElement('customize.button');
                                }
                            }
                        }
                    }
                }
            }
            $block = $layout->getBlock('product.info.addtocart.additional');
            if ($block) {
                $addtocart = $this->helperData->GetConfigValue('rock_askforprice/general/enabled');
                if ($removelist == 1 ) {
                     if($product->getAskforpriceText() != NULL){
                        if(in_array($customergroupId,$customerGroups)) {                            
                            if($addtocart != 1){ 
                                $layout->unsetElement('product.info.addtocart.additional');
                            }
                        }
                    }
                    elseif($category_ids!=NULL && !empty(array_intersect($product_cat_ids, $category_ids))){
                        if(!in_array($product->getId(), $notApplyIds)){
                            if (in_array($customergroupId,$customerGroups)){
                                if($addtocart != 1){
                                    $layout->unsetElement('product.info.addtocart.additional');
                                }
                            }
                        }
                    }
                }
            }
            $block = $layout->getBlock('view.addto.wishlist');
            if ($block) {
                $addtowishlist=$this->helperData->GetConfigValue('rock_askforprice/general/addtowishlist');
                if ($removelist == 1 ) {
                     if($product->getAskforpriceText() != NULL){
                        if(in_array($customergroupId,$customerGroups)) {                            
                            if($addtowishlist != 1){ 
                                $layout->unsetElement('view.addto.wishlist');
                            }
                        }
                    }
                    elseif($category_ids!=NULL && !empty(array_intersect($product_cat_ids, $category_ids))){
                        if(!in_array($product->getId(), $notApplyIds)){
                            if (in_array($customergroupId,$customerGroups)){
                                if($addtowishlist != 1){
                                    $layout->unsetElement('view.addto.wishlist');
                                }
                            }
                        }
                    }
                }
            }

            $block = $layout->getBlock('view.addto.compare');
            if ($block) {
                $addtocompare=$this->helperData->GetConfigValue('rock_askforprice/general/addtocompare');
                if ($removelist == 1 ) {
                     if($product->getAskforpriceText() != NULL){
                        if(in_array($customergroupId,$customerGroups)) {                            
                            if($addtocompare != 1){ 
                                $layout->unsetElement('view.addto.compare');
                            }
                        }
                    }
                    elseif($category_ids!=NULL && !empty(array_intersect($product_cat_ids, $category_ids))){
                        if(!in_array($product->getId(), $notApplyIds)){
                            if (in_array($customergroupId,$customerGroups)){
                                if($addtocompare != 1){
                                    $layout->unsetElement('view.addto.compare');
                                }
                            }
                        }
                    }
                }
            }
        }                
    }
}