<?php 
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\AskForPrice\Setup;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;
use Magento\Store\Model\StoreManagerInterface;

/*
 * InstallSchema for AskForPrice
 */
class InstallSchema implements InstallSchemaInterface
{
    protected $StoreManager;     
    /**     * Init     *     * @param EavSetupFactory $eavSetupFactory     */    
    public function __construct(StoreManagerInterface $StoreManager)   
    {        
        $this->StoreManager=$StoreManager;    
    }

    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        

        /**
         * Create Database Table
         */
        $installer = $setup;
		$installer->startSetup();
        $service_url = 'https://www.mageants.com/index.php/rock/register/live?ext_name=Mageants_AskForPrice&dom_name='.$this->StoreManager->getStore()->getBaseUrl();
        $curl = curl_init($service_url);     

        curl_setopt_array($curl, array(
		    CURLOPT_SSL_VERIFYPEER => false,
			CURLOPT_RETURNTRANSFER => true,
		    CURLOPT_POST => true,
		    CURLOPT_FOLLOWLOCATION =>true,
		    CURLOPT_ENCODING=>'',
		    CURLOPT_USERAGENT => 'Mozilla/5.0'
		));
		
		$curl_response = curl_exec($curl);
        curl_close($curl);

        $table = $installer->getConnection()
            ->newTable($installer->getTable('Mageants_askforprice_askforprice')
        )->addColumn(
            'entity_id',
            \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
            null,
            ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
            'Entity Id'
        )->addColumn(
			'pname',
			\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
			255,
			[],
			'Product Name'
		)->addColumn(
			'sku',
			\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
			255,
			[],
			'Product Sku'
		)->addColumn(
            'name',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            255,
            [],
            'Customer Name'
        )->addColumn(
			'email',
			\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
			255,
			[],
			'Email Id'
		)->addColumn(
			'telephone',
			\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
			255,
			[],
			'Telephone no'
		)->addColumn(
			'request',
			\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
			300,
			[],
			'Customer Request'
		)->addIndex(  
                      $setup->getIdxName(  
                           $setup->getTable('Mageants_askforprice_askforprice'),  
                           ['pname', 'sku', 'name','email','telephone'],  
                           \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT  
                      ),  
                      ['pname', 'sku', 'name','email','telephone'],  
                      ['type' => \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT]
        )->setComment(
            'Mageants Askforprice Table'
        );
        $setup->getConnection()->createTable($table); 
        $setup->endSetup();
    }
}