<?php
/**
 * @category Mageants AskForPrice
 * @package Mageants_AskForPrice
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants <support@mageants.com>
 */
namespace Mageants\Askforprice\Setup;
use Magento\Askforprice\Model\Product;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\UpgradeDataInterface;

/*
 * UpgradeData for AskForPrice
 */
class UpgradeData implements UpgradeDataInterface
{
    /**
     * EAV setup factory
     *
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    /**
     * Init
     *
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(EavSetupFactory $eavSetupFactory)
    {
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface   $context
     */
    public function upgrade(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $dbVersion = $context->getVersion();
        
        $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
        $eavSetup->addAttribute(
        \Magento\Catalog\Model\Product::ENTITY,
        'askforprice_textbox',
        [
        'group' => 'General',
        'type' => 'varchar',
        'backend' => '',
        'frontend' => '',
        'label' => 'Call/Hide Price Text',
        'input' => 'text',
        'class' => '',
        'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
        'visible' => true,
        'required' => false,
        'user_defined' => true,
        'default' => '',
        'searchable' => false,
        'filterable' => false,
        'comparable' => false,
        'visible_on_front' => false,
        'used_in_product_listing' => true,
        'unique' => false,
        'apply_to' => 'simple,configurable,virtual,bundle,downloadable'
        ]
        );

        $eavSetup->addAttribute(
        \Magento\Catalog\Model\Product::ENTITY,
        'askforprice_text',
        [
        'group' => 'General',
        'type' => 'varchar',
        'backend' => '',
        'frontend' => '',
        'label' => 'Call/Hide Price Type',
        'input' => 'select',
        'class' => '',
        'source' => 'Mageants\AskForPrice\Model\Config\Source\Options',
        'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
        'visible' => true,
        'required' => false,
        'user_defined' => true,
        'default' => '',
        'searchable' => false,
        'filterable' => false,
        'comparable' => false,
        'visible_on_front' => false,
        'used_in_product_listing' => true,
        'unique' => false,
        'apply_to' => 'simple,configurable,virtual,bundle,downloadable'
        ]
        );

        $eavSetup->addAttribute(
        \Magento\Catalog\Model\Product::ENTITY,
        'askforprice_customer_group',
        [
        'group' => 'General',
        'type' => 'text',
        'backend' => 'Magento\Eav\Model\Entity\Attribute\Backend\ArrayBackend',
        'frontend' => '',
        'label' => 'Call/Hide Price For Customer Group',
        'input' => 'multiselect',
        'class' => '',
        'source' => 'Mageants\AskForPrice\Model\Config\Source\Group\Multiselect',
        'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
        'visible' => true,
        'required' => false,
        'user_defined' => true,
        'default' => '',
        'searchable' => false,
        'filterable' => false,
        'comparable' => false,
        'visible_on_front' => false,
        'used_in_product_listing' => true,
        'unique' => false,
        'apply_to' => 'simple,configurable,virtual,bundle,downloadable'
        ]
        );
         
    }
}