<?php

namespace Magebird\Popup\Helper;

class Coupon extends \Magento\Framework\App\Helper\AbstractHelper
{
    protected $salesrule;
    protected $datetime;     
    protected $coupon;  
    protected $timezone;  
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\SalesRule\Model\Rule $salesrule,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $timezone,
        \Magento\SalesRule\Model\Coupon $coupon        
    ) {
        parent::__construct($context); 
        $this->salesrule = $salesrule;     
        $this->timezone = $timezone;
        $this->coupon = $coupon;   
    }
    
  public function generateCoupon($data, $popupId = false)
  {                        

      $expirationDate = isset($data['coupon_expiration']) ? $data['coupon_expiration'] : '';
    
      if(($expirationDate && $data['coupon_expiration']!='inherit') || ($expirationDate=='inherit' && $data['cpnExpInherit'])){
          if($data['coupon_expiration']=='inherit'){
            $expiration = date("Y-m-d H:i:s",$this->timezone->date()->getOffset()+time()+$data['cpnExpInherit']);
          }else{          
            $expiration = date("Y-m-d H:i:s",$this->timezone->date()->getOffset()+time()+($data['coupon_expiration']*60));            
          }                        
          $this->coupon->setExpirationDate($expiration);                                                        
      }elseif(isset($data['expiration_date']) and $data['expiration_date'] != ""){
          $this->coupon->setExpirationDate($data['expiration_date']);              
      }
                
      $length = isset($data['coupon_length']) ? $data['coupon_length'] : 12;
      $code = $this->randString($length);
      if(isset($data['coupon_prefix'])){
        $code = $data['coupon_prefix'].$code;
      }
      
      $nowTimestamp = time();
      //Show only once per IP?
      //means coupon info and user ip was stored in db because user needed to confirm subscription first      
      if(isset($data['user_ip'])){
        $ip = $data['user_ip'];        
      //means the data came directly from widget and not db, no confirmation was required
      }elseif(isset($data['coupon_limit_ip']) && $data['coupon_limit_ip']==1){
        $ip = $_SERVER['REMOTE_ADDR'];
      }else{
        $ip = '';
      }
      if(isset($data['popup_cookie_id'])){
        $this->coupon->setPopupCookieId($data['popup_cookie_id']);
      }         
                    
      if($popupId){
        $this->coupon->setIsPopup($popupId);
      }else{
        //it still need to be true and not empty or false, we put 5000 to make sure that id doesn't exist
        $this->coupon->setIsPopup(5000);
      }   
  
      $this->coupon->setId(null)
          ->setRuleId($data['rule_id'])
          ->setUsageLimit(1)
          ->setUsagePerCustomer(1)
          ->setCreatedAt($nowTimestamp)
          ->setType(\Magento\SalesRule\Helper\Coupon::COUPON_TYPE_SPECIFIC_AUTOGENERATED)
          ->setCode($code)
          ->setUserIp($ip)
          ->save();       
                                             
      return $code;
  }
  
  protected function randString($len){
      return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($len/strlen($x)) )),1,$len);  
  }     
}