<?php

namespace Milkinfotech\Llantaspara\Block;

use Magento\CatalogInventory\Model\Stock\StockItemRepository;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\ObjectManager;


class LlantaparaListData extends \Magento\Framework\View\Element\Template
{
	protected $_storeManager;

	private $_objectManager;

	protected $_resourceConnection;

	protected $_productCollectionFactory;

	protected $_productVisibility;

	protected $stockItemRepository;

	protected $_productloader;

	public function __construct(
		\Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
		\Magento\Framework\App\ResourceConnection $resourceConnection,
		\Magento\Framework\ObjectManagerInterface $objectmanager,
		\Magento\Catalog\Model\Product\Visibility $productVisibility,
		\Magento\Catalog\Model\ProductFactory $_productloader,
		\Magento\Store\Model\StoreManagerInterface $storemanager,
		\Magento\Eav\Model\Config $eavConfig,
		StockItemRepository $stockItemRepository,
		Context $context,
		array $data = []
	) {
		$this->_resourceConnection = $resourceConnection;
		$this->_objectManager = $objectmanager;
		$this->_productCollectionFactory = $productCollectionFactory;
		$this->_productVisibility = $productVisibility;
		$this->stockItemRepository = $stockItemRepository;
		$this->_productloader = $_productloader;
		$this->_storeManager =  $storemanager;
		$this->eavConfig = $eavConfig;
		parent::__construct($context, $data);
	}

	public function _prepareLayout()
	{
		$this->pageConfig->getTitle()->set(__('Venta de Llantas por Vehículo'));
		return parent::_prepareLayout();
	}


	public function url_slug($str, $options = array())
	{
		$str = mb_convert_encoding((string) $str, 'UTF-8', mb_list_encodings());
		$defaults = array(
			'delimiter' => '-',
			'limit' => null,
			'lowercase' => true,
			'replacements' => array(),
			'transliterate' => false,
		);

		// Merge options
		$options = array_merge($defaults, $options);
		$char_map = array(
			// Latin
			'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A', 'Æ' => 'AE', 'Ç' => 'C',
			'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I',
			'Ð' => 'D', 'Ñ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O', 'Ő' => 'O',
			'Ø' => 'O', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'U', 'Ű' => 'U', 'Ý' => 'Y', 'Þ' => 'TH',
			'ß' => 'ss',
			'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a', 'æ' => 'ae', 'ç' => 'c',
			'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i',
			'ð' => 'd', 'ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o', 'ő' => 'o',
			'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ü' => 'u', 'ű' => 'u', 'ý' => 'y', 'þ' => 'th',
			'ÿ' => 'y',
			// Latin symbols
			'©' => '(c)',
			// Greek
			'Α' => 'A', 'Β' => 'B', 'Γ' => 'G', 'Δ' => 'D', 'Ε' => 'E', 'Ζ' => 'Z', 'Η' => 'H', 'Θ' => '8',
			'Ι' => 'I', 'Κ' => 'K', 'Λ' => 'L', 'Μ' => 'M', 'Ν' => 'N', 'Ξ' => '3', 'Ο' => 'O', 'Π' => 'P',
			'Ρ' => 'R', 'Σ' => 'S', 'Τ' => 'T', 'Υ' => 'Y', 'Φ' => 'F', 'Χ' => 'X', 'Ψ' => 'PS', 'Ω' => 'W',
			'Ά' => 'A', 'Έ' => 'E', 'Ί' => 'I', 'Ό' => 'O', 'Ύ' => 'Y', 'Ή' => 'H', 'Ώ' => 'W', 'Ϊ' => 'I',
			'Ϋ' => 'Y',
			'α' => 'a', 'β' => 'b', 'γ' => 'g', 'δ' => 'd', 'ε' => 'e', 'ζ' => 'z', 'η' => 'h', 'θ' => '8',
			'ι' => 'i', 'κ' => 'k', 'λ' => 'l', 'μ' => 'm', 'ν' => 'n', 'ξ' => '3', 'ο' => 'o', 'π' => 'p',
			'ρ' => 'r', 'σ' => 's', 'τ' => 't', 'υ' => 'y', 'φ' => 'f', 'χ' => 'x', 'ψ' => 'ps', 'ω' => 'w',
			'ά' => 'a', 'έ' => 'e', 'ί' => 'i', 'ό' => 'o', 'ύ' => 'y', 'ή' => 'h', 'ώ' => 'w', 'ς' => 's',
			'ϊ' => 'i', 'ΰ' => 'y', 'ϋ' => 'y', 'ΐ' => 'i',
			// Turkish
			'Ş' => 'S', 'İ' => 'I', 'Ç' => 'C', 'Ü' => 'U', 'Ö' => 'O', 'Ğ' => 'G',
			'ş' => 's', 'ı' => 'i', 'ç' => 'c', 'ü' => 'u', 'ö' => 'o', 'ğ' => 'g',
			// Russian
			'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'Yo', 'Ж' => 'Zh',
			'З' => 'Z', 'И' => 'I', 'Й' => 'J', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O',
			'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'H', 'Ц' => 'C',
			'Ч' => 'Ch', 'Ш' => 'Sh', 'Щ' => 'Sh', 'Ъ' => '', 'Ы' => 'Y', 'Ь' => '', 'Э' => 'E', 'Ю' => 'Yu',
			'Я' => 'Ya',
			'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ё' => 'yo', 'ж' => 'zh',
			'з' => 'z', 'и' => 'i', 'й' => 'j', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o',
			'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'c',
			'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sh', 'ъ' => '', 'ы' => 'y', 'ь' => '', 'э' => 'e', 'ю' => 'yu',
			'я' => 'ya',
			// Ukrainian
			'Є' => 'Ye', 'І' => 'I', 'Ї' => 'Yi', 'Ґ' => 'G',
			'є' => 'ye', 'і' => 'i', 'ї' => 'yi', 'ґ' => 'g',
			// Czech
			'Č' => 'C', 'Ď' => 'D', 'Ě' => 'E', 'Ň' => 'N', 'Ř' => 'R', 'Š' => 'S', 'Ť' => 'T', 'Ů' => 'U',
			'Ž' => 'Z',
			'č' => 'c', 'ď' => 'd', 'ě' => 'e', 'ň' => 'n', 'ř' => 'r', 'š' => 's', 'ť' => 't', 'ů' => 'u',
			'ž' => 'z',
			// Polish
			'Ą' => 'A', 'Ć' => 'C', 'Ę' => 'e', 'Ł' => 'L', 'Ń' => 'N', 'Ó' => 'o', 'Ś' => 'S', 'Ź' => 'Z',
			'Ż' => 'Z',
			'ą' => 'a', 'ć' => 'c', 'ę' => 'e', 'ł' => 'l', 'ń' => 'n', 'ó' => 'o', 'ś' => 's', 'ź' => 'z',
			'ż' => 'z',
			// Latvian
			'Ā' => 'A', 'Č' => 'C', 'Ē' => 'E', 'Ģ' => 'G', 'Ī' => 'i', 'Ķ' => 'k', 'Ļ' => 'L', 'Ņ' => 'N',
			'Š' => 'S', 'Ū' => 'u', 'Ž' => 'Z',
			'ā' => 'a', 'č' => 'c', 'ē' => 'e', 'ģ' => 'g', 'ī' => 'i', 'ķ' => 'k', 'ļ' => 'l', 'ņ' => 'n',
			'š' => 's', 'ū' => 'u', 'ž' => 'z'
		);
		// Make custom replacements
		$str = preg_replace(array_keys($options['replacements']), $options['replacements'], $str);
		// Transliterate characters to ASCII
		if ($options['transliterate']) {
			$str = str_replace(array_keys($char_map), $char_map, $str);
		}
		// Replace non-alphanumeric characters with our delimiter
		$str = preg_replace('/[^\p{L}\p{Nd}]+/u', $options['delimiter'], $str);
		// Remove duplicate delimiters
		$str = preg_replace('/(' . preg_quote($options['delimiter'], '/') . '){2,}/', '$1', $str);
		// Truncate slug to max. characters
		$str = mb_substr($str, 0, ($options['limit'] ? $options['limit'] : mb_strlen($str, 'UTF-8')), 'UTF-8');
		// Remove delimiter from ends
		$str = trim($str, $options['delimiter']);
		return $options['lowercase'] ? mb_strtolower($str, 'UTF-8') : $str;
	}

	public function getBrands()
	{
		$connection = $this->_resourceConnection->getConnection();
		$tableName =  $this->_resourceConnection->getTableName('buscadorllantas');
		$query = $connection->select()->from($tableName)->where('tyres_factory != ?', '')->group('vendor')->order('vendor ASC');
		$collection = $connection->fetchAll($query);
		return $collection;
	}

	public function getModels($vendor)
	{
		$connection = $this->_resourceConnection->getConnection();
		$tableName =  $this->_resourceConnection->getTableName('buscadorllantas');
		$query = $connection->select()->from($tableName)
			->where('vendor_slug = ?', $vendor)
			->where('tyres_factory != ?', '')
			->group('car')->order('car ASC');
		$collection = $connection->fetchAll($query);
		return $collection;
	}


	public function getYears($model, $vendor)
	{
		$connection = $this->_resourceConnection->getConnection();
		$tableName =  $this->_resourceConnection->getTableName('buscadorllantas');
		$query = $connection->select()->from($tableName)
			->where('vendor_slug = ?', $vendor)
			->where('car_slug = ?', $model)
			->where('tyres_factory != ?', '')
			->group('year')->order('year ASC');
		$collection = $connection->fetchAll($query);
		return $collection;
	}

	public function getModification($model, $vendor, $year)
	{
		$connection = $this->_resourceConnection->getConnection();
		$tableName =  $this->_resourceConnection->getTableName('buscadorllantas');
		$query = $connection->select()->from($tableName)
			->where('vendor_slug = ?', $vendor)
			->where('car_slug = ?', $model)
			->where('year = ?', $year)
			->where('tyres_factory != ?', '')
			->group('modification')->order('modification ASC');
		$collection = $connection->fetchAll($query);
		return $collection;
	}


	public function getVersion($model, $vendor, $year, $version)
	{
		$search="";
		$connection = $this->_resourceConnection->getConnection();
		$tableName =  $this->_resourceConnection->getTableName('buscadorllantas');
		$query = $connection->select()->from($tableName)
			->where('vendor_slug = ?', $vendor)
			->where('car_slug = ?', $model)
			->where('year = ?', $year)
			->where('modification_slug = ?', $version)
			->group('tyres_factory');
	
		$collection = $connection->fetchAll($query);

		foreach ($collection as $result) {
			$attribute = $this->eavConfig->getAttribute('catalog_product', 'medida');
			$_options = $attribute->getSource()->getAllOptions();
			$selectedvalue = str_ireplace("185/R14", "185-R14", str_ireplace(".5/R", ".50-R", str_ireplace("10/R15", "10-R15", $result['tyres_factory'])));
			
			foreach($_options as $key => $value){
				    if(in_array( $selectedvalue, $value)){
						if($value['label'] === $selectedvalue){
							$search = $value['value'];
						}
					continue;
					}
                }
		} 

		$_productCollection = $this->_productCollectionFactory->create();

		$_productCollection->addAttributeToSelect('*');

		// filter current website products
		$_productCollection->addWebsiteFilter();

		// filter current store products
		$_productCollection->addStoreFilter();

		
		// set visibility filter
		$_productCollection->addAttributeToFilter('visibility', $this->_productVisibility::VISIBILITY_BOTH);

		$_productCollection->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED);

		// set medida_valor filter
		//$_productCollection->addAttributeToFilter('medida', array('like' => '%'.$search.'%'));
		$_productCollection->addAttributeToFilter('medida', $search);

		// set order by filter
		$_productCollection->setOrder('price', 'ASC');

		//echo $_productCollection->count(); die;

		//echo $_productCollection->getSelect()->__toString(); die;
		return $_productCollection;
	}

	public function getStockItem($productId)
	{
		return $this->stockItemRepository->get($productId);
	}

	public function getProductImage($pId)
	{
		$store = $this->_storeManager->getStore();
		$_product = $this->_productloader->create()->load($pId);
		$productImageUrl = $store->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) . 'catalog/product' . $_product->getImage();
		return $productImageUrl;
	}
	
	public function getPagerHtml()
	{
		return $this->getChildHtml('pager');
	}
}
