<?php
declare(strict_types=1);

namespace Milkinfotech\Llantaspara\Controller\Index;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\View\Result\Page;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;


class Index extends \Magento\Framework\App\Action\Action
{
	protected $resultPageFactory;

	protected $session;

	public function __construct(
		\Magento\Framework\App\Action\Context $context,
		\Magento\Customer\Model\Session $customerSession,
		PageFactory $resultPageFactory
	) {
		$this->session = $customerSession;
		parent::__construct($context);
		$this->resultPageFactory = $resultPageFactory;
	}

	public function execute()
	{
		$resultPage = $this->resultPageFactory->create();

		$sql_inject_prev = array("'", '"', "`", '&', ',', ';', ' SELECT ', ' WHERE ', ' AND ');
		$sql_inject_out = array("", '', "", '', '', '', '', '', '');

		$url = $_SERVER['REQUEST_URI'];
		$url_str = rtrim($url, '/');

		$str = str_replace($sql_inject_prev, $sql_inject_out, $url_str);

		$seccion =  explode("/", $str);
		$ultimo_slash = substr(strrchr(rtrim($str, '/'), '/'), 1);

		$vehiculo 			= @$seccion[1];
		$marca 				= @$seccion[2];
		$modelo 			= @$seccion[3];
		$year 				= @$seccion[4];
		$version 			= @$seccion[5];

		if ($ultimo_slash == $vehiculo) {
			$pageMainTitle = $resultPage->getLayout()->getBlock('page.main.title');
			if ($pageMainTitle) {
				$pageMainTitle->setPageTitle(__('Venta de Llantas por Vehículo'));
			}

			$resultPage->getConfig()->setKeywords(__('llantas por vehiculo, llantas para nissan, llantas para toyota, llantas para ford, llantas para volkswagen, llantas para audi, llantas para bmw, llantas para dodge, llantas para peugeot, llantas para volvo, llantas para seat, llantas para mercedes, llantas para honda, llantas para hummer, llantas para fiat, llantas para gmc, llantas para chevrolet'));
			$resultPage->getConfig()->setDescription(__('Entra y selecciona la marca y modelo de tu Vehículo, tenemos las mejores marcas y precios en Llantas ¡Entra ahora!'));
		} elseif ($ultimo_slash == $marca || $ultimo_slash == $modelo || $ultimo_slash == $year || $ultimo_slash == $version) {
			if (stripos($str, (string)$marca) !== false) {
				$pageMainTitle = $resultPage->getLayout()->getBlock('page.main.title');
				if ($pageMainTitle) {
					$pageMainTitle->setPageTitle(__('Llantas para ' . ucwords(str_replace("-"," ",$marca)) . ''));
				}
			}
			if (stripos($str, (string)$modelo) !== false) {
				$pageMainTitle = $resultPage->getLayout()->getBlock('page.main.title');
				if ($pageMainTitle) {
					$pageMainTitle->setPageTitle(__('Llantas para ' . ucwords(str_replace("-"," ",$marca)) . ' ' . ucwords(str_replace("-"," ",$modelo)) . ''));
				}
			}
			if (stripos($str, (string)$year) !== false) {
				$pageMainTitle = $resultPage->getLayout()->getBlock('page.main.title');
				if ($pageMainTitle) {
					$pageMainTitle->setPageTitle(__('Llantas para ' . ucwords(str_replace("-"," ",$marca)) . ' ' . ucwords(str_replace("-"," ",$modelo)) . ' ' . $year . ''));
				}
			}
			if (stripos($str, (string)$version) !== false) {
				$pageMainTitle = $resultPage->getLayout()->getBlock('page.main.title');
				if ($pageMainTitle) {
					$pageMainTitle->setPageTitle(__('Llantas para ' . ucwords(str_replace("-"," ",$marca)) . ' ' . ucwords(str_replace("-"," ",$modelo)) . ' ' . $year . ' ' . ucwords(str_replace("-"," ",$version)) . ''));
				}
			}
			$resultPage->getConfig()->getTitle()->set('Venta de Llantas para ' . ucwords(str_replace("-"," ",$marca)) . " " . ucwords(str_replace("-"," ",$modelo)) . " " . $year . " " . ucwords(str_replace("-"," ",$version)) . ' > Hasta 30% OFF');
			$resultPage->getConfig()->setDescription(__('Venta de Llantas para ' . ucwords(str_replace("-"," ",$marca)) . " " . ucwords(str_replace("-"," ",$modelo)) . " " . $year . " " . ucwords(str_replace("-"," ",$version)) . " al mejor precio, ¡Entra Ahora!"));
			$resultPage->getConfig()->setKeywords(__('Llantas para ' . ucwords(str_replace("-"," ",$marca)) . " " . ucwords(str_replace("-"," ",$modelo)) . " " . $year . " " . ucwords(str_replace("-"," ",$version))));
		}
		return $resultPage;
	}
}
