<?php

namespace Mirasvit\Blog\Model;

use Magento\Framework\App\ObjectManager;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\User\Model\User;

/**
 * @method string getName()
 * @method $this setName($name)
 * @method string getUrlKey()
 */
class Author extends User implements IdentityInterface, UrlInterface
{
    const CACHE_TAG = 'blog_author';

    /**
     * Get identities.
     * @return array
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @param array $urlParams
     *
     * @return string
     */
    public function getUrl($urlParams = [])
    {
        /** @var Url $url */
        $url = ObjectManager::getInstance()->get('Mirasvit\Blog\Model\Url');

        return $url->getAuthorUrl($this, $urlParams);
    }

    /**
     * {@inheritdoc}
     */
    public function afterSave()
    {
        return parent::afterSave(); // TODO: Change the autogenerated stub
    }
}
