# Configuration Settings

All configuration settings are located at **Content -> Blog MX -> Settings** section, and breaks into following subsections:
* [**Appearance**](/guide/settings#appearance) - defines blog main page and articles appearance.
* [**Display**](/guide/settings#display) - governs menu display options
* [**Search Engine Optimization**](/guide/settings#search) - defines metadata, that can be used by search crawlers
* [**Comments**](/guide/settings#comments) - governs possibility for customers to leave comments
* [**Sharing**](/guide/settings#sharing) - allows to display social buttons on blog article pages

<a name="appearance"></a>
## Appearance

Option  | Description
------------- | -------------
Top Menu Name | Defines menu title for Magento 2 Top Link Menu.
Blog Name | Defines main header for Blog MX main page (accessed via direct click on Top Link Menu item, or using base URL)
Date Format | Defines date format, in which displayed date of blog publishing. It resembles [Wordpress date format](https://codex.wordpress.org/Formatting_Date_and_Time).

<a name="display"></a>
## Display

Option  | Description
------------- | -------------
Visible Navigation Menu  | Turns on/off Top Link Menu, defined in previous subsection. After changing this option, purge **ALL** cache to make changes apply.

<a name="search"></a>
## Search Engine Optimization

Option  | Description
------------- | -------------
Base URL  | Sets base URL for Blog MX main page.
Base Meta Title  | Defines meta title for Blog MX main page
Base Meta Description  | Defines meta description for Blog MX main page
Base Meta Keywords  | Defines keywords for Blog MX main page.
URL Suffix for Posts  | Defines default suffix (file extension) for generated Posts pages (**.html** by default).
URL Suffix for Categories  | Defines default suffix (file extension) for generated Categories pages (**.html** by default).

<a name="comments"></a>
## Comments

Option  | Description
------------- | -------------
Provider  | Defines current provider for commenting blogs. There are the following options available: **Disable comments**, **Disqus** and **Facebook**.
Disqus Blog Shortname  | Additional field, displayed only when **Disqus** provider is selected. Shortname is needed for managing comments. Read more [here](https://help.disqus.com/customer/portal/articles/466208-what-s-a-shortname-).

<a name="sharing"></a>
## Sharing

Option  | Description
------------- | -------------
Enable AddThis Sharing Buttons  | Displays social buttons block from AddThis service. By default Facebook, Twitter and Messenger are shown. Read more [here](http://www.addthis.com/get/share).
