<?php

namespace Misterllantas\Atrato\Controller\Index;

use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\RequestInterface;
use Misterllantas\Atrato\Logger\Logger;
use Magento\Framework\HTTP\PhpEnvironment\RemoteAddress;
use Magento\Framework\Controller\Result\RedirectFactory;


class Index extends \Magento\Framework\App\Action\Action
{

    protected $resultRedirect;
    protected $logger;
    private $remoteAddress;

    public function __construct(
        Context $context,
        ResultFactory  $resultFactory,
        RequestInterface $request,
        Logger $logger,
        RemoteAddress $remoteAddress,
        RedirectFactory $resultRedirectFactory

    ) {
        parent::__construct($context);
        $this->resultFactory = $resultFactory;
        $this->request = $request;
        $this->logger = $logger;
        $this->remoteAddress = $remoteAddress;
        $this->resultRedirectFactory = $resultRedirectFactory;
    }

    public function execute()
    {
        $monto = $this->getRequest()->getParam('monto');
        $origen = $this->getRequest()->getParam('origen');

        if (is_numeric($monto)) {
            if (!empty($monto) && !empty($origen)) {
                $com = 144;
                $suc = 374;
                $dis = 1;
                $isQuincenal = 0;
                $numeroPagos = 18;
                $ip = $this->remoteAddress->getRemoteAddress();

                if ($monto < 1500) {
                    $this->logger->info($monto . ' - ' . $ip . ' - ' . $origen);
                    $this->messageManager->addError('El monto debe ser mayor a 15000');
                    // Redirect to your form page (or anywhere you want...)
                    $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
                    $resultRedirect->setUrl('/atrato/index/');
                    return $resultRedirect;
                }

                $this->logger->info($monto . ' - ' . $ip . ' - ' . $origen);
                return $this->testRedirect($monto);
            }
        }
        $this->messageManager->addError('Debe de ser numerico');
        //renderiza el formulario
        $this->_view->loadLayout();
        $this->_view->renderLayout();
    }
    public function testRedirect($monto)
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $resultRedirect->setUrl('https://www.atratopago.com/formulario?com=144&suc=374&dis=1&isQuincenal=0&numeroPagos=18&monto=' . $monto);
        return $resultRedirect;
    }
}
