<?php

namespace Misterllantas\Buscadorllantas\Controller\Index;

use Magento\Eav\Model\Config;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Controller\Result\JsonFactory;

class Alto extends Action
{
    private $resultJsonFactory;

    private $_productCollectionFactory;

    private $eavConfig;
    /**
     * Index constructor.
     * @param Context $context
     * @param PageFactory $pageFactory
     */
    public function __construct(
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\Product\Visibility $productVisibility,
        Config $eavConfig,
        Context $context,
        JsonFactory $resultJsonFactory
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->_productCollectionFactory = $productCollectionFactory;
        $this->_productVisibility = $productVisibility;
        $this->eavConfig = $eavConfig;
    }

    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Json $result */
        $result = $this->resultJsonFactory->create();
        $collections = $this->processAltoLlanta();
        if (!empty($collections)) {
            return $result->setData([
                'success' => true,
                'result' => $collections
            ]);
        } else {
            return $result->setData([
                'success' => false,
                'result' => 'null'
            ]);
        }
    }

    public function processAltoLlanta()
    {
        $resultAtributeAlto = [];
        $ancho = $this->getRequest()->getParam('ancho');

        if (isset($ancho) && !empty($ancho)) {
            $atribute_Ancho = $this->getAnchoAtribute($ancho);
            $arrayAtributeAlto = $this->getAltoAtributeCollection($atribute_Ancho);
            $arrayAtributeAlto = array_unique($arrayAtributeAlto);

            foreach ($arrayAtributeAlto as $item) {
                array_push($resultAtributeAlto, $this->getAltoAtribute($item));
            }
            sort($resultAtributeAlto);
            return $resultAtributeAlto;
        }
    }

    public function getAnchoAtribute($ancho)
    {
        $attribute = $this->eavConfig->getAttribute('catalog_product', 'ancho');
        $_options = $attribute->getSource()->getAllOptions();

        foreach ($_options as $key => $value) {
            if ($value['label'] === $ancho) {
                $ancho_value = $value['value'];
            }
            continue;
        }
        if (!empty($ancho_value)) {
            return $ancho_value;
        } else {
            return $ancho_value = null;
        }
    }

    public function getAltoAtributeCollection($ancho_value)
    {
        $collection = [];
        $_productCollection = $this->_productCollectionFactory->create();
        $_productCollection->addAttributeToSelect('alto');
        $_productCollection->distinct(true);
        $_productCollection->setVisibility(\Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH);
        $_productCollection->addAttributeToFilter('ancho', array('eq' =>  $ancho_value));
        $_productCollection->setOrder('alto', 'ASC');
        $_productCollection->groupByAttribute('alto');
        
        foreach ($_productCollection as $option) {
            array_push($collection, $option['alto']);
        }
        return $collection;
    }

    public function getAltoAtribute($alto)
    {
        $resultArray = [];
        $attribute = $this->eavConfig->getAttribute('catalog_product', 'alto');
        $_options = $attribute->getSource()->getAllOptions();

        foreach ($_options as $key => $value) {
            if ($value['value'] === $alto) {
                array_push($resultArray, $value['label']);
            }
            continue;
        }
        return $resultArray;
    }
}
