<?php

namespace Misterllantas\Buscadorllantas\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Controller\Result\JsonFactory;

class Ancho extends Action
{
    private $resultJsonFactory;
    private $eavConfig;
    private $_productCollectionFactory;

    /**
     * Index constructor.
     * @param Context $context
     * @param PageFactory $pageFactory
     */
    public function __construct(
        \Magento\Eav\Model\Config $eavConfig,
        Context $context,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\Product\Visibility $productVisibility,
        JsonFactory $resultJsonFactory
    ) {
        parent::__construct($context);
        $this->_productCollectionFactory = $productCollectionFactory;
        $this->_productVisibility = $productVisibility;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->eavConfig = $eavConfig;
    }


    /**
     * Execute action based on request and return result
     *
     * Note: Request will be added as operation argument in future
     *
     * @return ResultInterface|ResponseInterface
     * @throws NotFoundException
     */
    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Json $result */

        $result = $this->resultJsonFactory->create();
        //$collections = $this->getAnchoLlanta();
        $collections =  $this->getAnchoAtributeCollection();
        if (!empty($collections) && count($collections) > 0) {
            return $result->setData([
                'success' => true,
                'result' => $collections
            ]);
        } else {
            return $result->setData([
                'success' => false,
                'result' => 'null'
            ]);
        }
    }

    public function getAnchoLlanta()
    {
        $ancho_value = [];
        $attribute = $this->eavConfig->getAttribute('catalog_product', 'ancho');
        $_options = $attribute->getSource()->getAllOptions();
        foreach ($_options as $key => $value) {
            array_push($ancho_value, $value['label']);
        }
        asort($ancho_value);
        unset($ancho_value[0],$ancho_value[1]);
        return $ancho_value;
    }

    public function getAnchoAtributeCollection() //fuxz 15-04-2020 6:10pm
    {
        $collection = [];
        $_productCollection = $this->_productCollectionFactory->create();
        $_productCollection->addAttributeToSelect('ancho');
        $_productCollection->distinct(true);
        $_productCollection->setVisibility(\Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH);
        $_productCollection->addAttributeToFilter('status',\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED);
        $_productCollection->setOrder('ancho', 'ASC');
        $_productCollection->groupByAttribute('ancho');

        foreach ($_productCollection as $option) {
            $ToTexto = str_ireplace(".", "_", $option->getAttributeText('ancho'));
            array_push($collection, $ToTexto);
        }

        sort($collection);
        return $collection;
    }
}
